//'use strict';

//* INIT GLOBALS *//
// disable animations on resize
var resizeTimer;
window.onresize = function (e) {
  var body = document.getElementsByTagName("BODY")[0];
  body.classList.add("resize-on");
  clearTimeout(resizeTimer);
  resizeTimer = setTimeout(function () {
    body.classList.remove("resize-on");
  }, 250);
};

(function(o,$){
  if( !o || !$ ) return false;
  var $o = $(o);
  $o.ready(function(){
    $o.removeClass('hideBody');
  });
})(document.querySelector('body'),window.jQuery);

(function( o, $, h ){
  if( !o || !$ || !h ) return false;

  var lis = o.querySelectorAll('.fn-listaLink .fn-listaLinkElement'),
  listMenu = o.querySelector('.sta-menus-air_links-wrapper');
  for (var i = 0; i < lis.length; i++) {
    (function( li, $li ){
      
      //enlaces _blank
      var as = li.querySelectorAll('a');
      for (var i = 0; i < as.length; i++) h.enlace_blank( $( as[i] ) );


      if( $li.hasClass('sta-noChild') || !$('.fn-listaLinkHijos .sta-menus-air_links-element',$li).length )
        $('.fn-listaLinkHijos',$li).remove();
      
      if ($li.hasClass("sta-child")) {
        if (!$li.hasClass("sta-link")) {
          $li.addClass("no_link");
          $($li[0].querySelector("a")).removeAttr("href").attr("role", "button");
        }
      }

    })( lis[i], $(lis[i]) );
  };

  //Scroll top
  h.controlTop(o);
  
  // idiomas
  (function ( o2 ) {
    if( !o2 ) return false;
    var input = o2.querySelector('input'),
    body = document.querySelector('body'),
    list = o2.querySelector('.sta-menus-air_languages-list').children,
    listTotal = list.length;

    if( listTotal > 1 ){
      for (var i = list.length - 1; i >= 0; i--) {
        (function( li ) {
          var href1 = $( li.querySelector('a.sta-menus-air_element-btn') ).attr('href').substr(-10),
          href2 = $( li.querySelector('a.sta-menus-air_element-btn') ).attr('href').substr(-6);
          if( href1 == '/index.php' || href2 == '/.html' ){
            li.remove();
            listTotal--;
          };
        })( list[i] );
      };

      if( listTotal > 1 ){
        o2.onclick = function () {
          input.checked = !input.checked;

          //control de z-index for dispo
          input.checked
          ? o.classList.add("sta-indexDispo")
          : o.classList.remove("sta-indexDispo");
          

          if (window.innerWidth < 1280) {
            if (!o.querySelector('.sta-menus-air_nav-links').classList.contains('fn-open')) {
              if ( body.classList.contains('noscroll')) {
                body.classList.remove('noscroll');
              } else {
                body.classList.add('noscroll');
              }
            } else {
              o.querySelector('.sta-menus-air_nav-links').classList.remove('fn-open');
              o.classList.remove('sta-openMenu');
              o.querySelector('.sta-menus-air_nav-btns-element.js-toggle-menu').classList.remove('fn-close');
            }
          } else {
            if (o.querySelector('.sta-menus-air_nav-links').classList.contains('fn-open')) {
              body.classList.add('noscroll');
            } else {
              body.classList.remove('noscroll');
            }
          }
        };

        //add idioma in menu
        if( window.innerWidth <= 500 ){
          var $btn = $('<div></div>',{class:'sta-menus-air_links-element-wrapper'})
          .append( $('<p></p>',{class:'sta-menus-air_links-element-text'}).text( $(o2).data('text-menu') ) ),
          $li = $('<li></li>',{class:'sta-menus-air_links-element sta-idiomasMenu js-menu-placeholder fn-listaLinkElement'}).append( $btn );
  
          $(listMenu).append( $li );
          $btn.click(function(){
            o2.click();
          });
        }

      } else {
        o2.classList.add('sta-notIdiomas')
      };
    } else {
      o2.classList.add('sta-notIdiomas');
    };

  })( o.querySelector('.sta-menus-air_nav-morebtns-element.sta-lang') );

  //telefonos
  (function( o2,seo ){
    if( !o2 || !seo || !seo.hotel ) return false;

    var bTel = false,
    $lista = $( o2.querySelector('.sta-menus-air_morebtns-element-hover') );

    if( seo.hotel.tel && seo.hotel.tel.trim() ){
      $lista.append( $('<a></a>',{id: 'td-d1-telefonosuperior-03', href : 'tel:' + seo.hotel.tel.replace(/\s/g,'') }).text( seo.hotel.textTel ? seo.hotel.textTel : seo.hotel.tel ) );
      bTel = true;
    }
    if( seo.hotel.tel2 && seo.hotel.tel2.trim() ){
      $lista.append( $('<a></a>',{id: 'td-d1-telefonosuperior-04', href : 'tel:' + seo.hotel.tel2.replace(/\s/g,'') }).text( seo.hotel.text2Tel ? seo.hotel.text2Tel : seo.hotel.tel2 ) );
      bTel = true;
    }
    if( seo.hotel.whatsapp && seo.hotel.whatsapp.trim() ){
      $lista.append( $('<a></a>',{id: 'td-d1-telefonosuperior-05', target:'_blank', href:'https://api.whatsapp.com/send/?phone=' + seo.hotel.whatsapp.replace(/\s/g,'') + '&text&app_absent=0' }).text( '+' + seo.hotel.whatsapp ).addClass('sta-whatsapp') );
      bTel = true;
    }
    if( !bTel ) o2.remove();

  })( o.querySelector('.sta-menus-air_nav-morebtns-element.sta-tels'), window.dataSeo );

  // function check menu reserva existe
  var bookBtn = o.querySelectorAll('.sta-scroll-book'),
    menu = o.querySelector('.sta-menus-air_nav-btns-element.js-toggle-menu'),
    menuDiv = o.querySelector('.sta-main-links'),
    body = document.querySelector('body');

  if (bookBtn && menu && menuDiv) {

    for (var i = 0; i < bookBtn.length; i++) {
      (function(btn){

        btn.addEventListener('click', function () {
          var clase = 'fn-open',
            clase2 = 'fn-close',
            clase3 = 'noscroll';
    
          if (menuDiv.classList.contains(clase)) {
            menuDiv.classList.remove(clase);
          }
          if (menu && menu.classList.contains(clase2)) {
            menu.classList.remove(clase2);
          }
          if (body.classList.contains(clase3)) {
            body.classList.remove(clase3);
          }
        });

      })(bookBtn[i])
      
    }

  }

})(document.querySelector('.tgl-menus-air'), window.jQuery, window.hotusa && hotusa());

// create datos estructurados ld+json Hotel
var crearDatosExtructurados = (function(datos) {
  if( datos ){
    function crearDatos(src){
      if( !creado ){
        creado = true;
        dataSeo.imgFirst = src;
        _tmp.image = src;
        var script = document.createElement('script');
        script.type = "application/ld+json";
        script.title = "Hotel";
        script.innerHTML = JSON.stringify(_tmp);
        $('head').append(script);
        crearDatosExtructurados = false;
      };
    };
    var creado = false,
    _tmp = {
      "@context"  : "http://www.schema.org",
      "@type"     : "Hotel",
      name        : datos.hotel.name,
      url         : datos.hotel.url,
      logo        : datos.favicon,
      image       : null,
      description : datos.metaHome,
      address     : {
        "@type"         : "PostalAddress",
        streetAddress   : datos.hotel.address,
        addressLocality : datos.hotel.city,
        postalCode      : datos.hotel.cp,
        addressCountry  : datos.hotel.country
      },
      geo         : {
        "@type"   : "GeoCoordinates",
        latitude  : datos.hotel.coord.lat,
        longitude : datos.hotel.coord.log
      },
      priceRange      : datos.seo.text1,
      telephone       : datos.hotel.tel,
      faxNumber       : datos.hotel.fax,
      email           : datos.hotel.mail
    };
    if( datos.seo.text2.trim() ) _tmp.openingHours = datos.seo.text2;
    if( datos.opinions.nota && datos.opinions.count ) _tmp.aggregateRating = {
      "@type" : "AggregateRating",
      ratingValue : datos.opinions.nota,
      reviewCount : datos.opinions.count,
      bestRating  : datos.opinions.max,
      worstRating : datos.opinions.min
    };
    return crearDatos;
  } else {
    return false;
  };
})(window.dataSeo);

//create html galleryV1
(function( o, $, json, h ){
  if( !o || !$ || !json || !h ) return false;

  var createImg = function( obj ){
    var alt = obj.text ? nameHotel + obj.text : nameHotel + obj.zone + ' '+ (obj.posi+1),
    str = '<div class="sta-gallery-air_mosaic-element" data-zone="' + obj.zone + '">' +
      '<div class="sta-gallery-air_mosaic-element-wrapper">' +
        '<a href="'+obj.imgG+'" aria-label="'+alt+'" data-lightbox="all">' +
          '<div class="sta-gallery-air_mosaic-multimedia">' +
            '<figure class="sta-gallery-air_mosaic-photo" data-lazyimg="'+obj.imgP+'" role="img" aria-label=""></figure>' +
          '</div>' +
          '<div class="sta-gallery-air_mosaic-info">';
          if( obj.text ) str+= '<p class="sta-gallery-air_mosaic-info-title">' + obj.text + '</p>';
          str += '<i class="sta-gallery-air_mosaic-info-icon icon-zoom"></i>' +
          '</div>' +
        '</a>' +
      '</div>' +
    '</div>';
    return str;
  },
  nameHotel = window.dataSeo && dataSeo.hotel && dataSeo.hotel.name && dataSeo.hotel.name.trim() ? dataSeo.hotel.name.trim() + ' - ' : '',
  $content = $( o.querySelector('.sta-gallery-air_mosaic-list') );

  //multigalery
  for (var i = 0; i < json.length; i++) {
    (function(zona, nameZone){
      for (var i2 = 0; i2 < zona.photos.length; i2++) {
        $content.append( createImg( { zone : nameZone, imgG : zona.photos[i2].url, imgP : zona.photos[i2].url, text : zona.photos[i2].name, posi:i2 } ) );
      };
    })( json[i], encodeURI(json[i].name) );
  };

  loadScript('/templates/cadenas/air/js/gallery.min.js',new Function);

})( document.querySelector('.fn-galleryV1'), window.jQuery, window.json_multiGalerias, window.hotusa && hotusa() );

//create html galleryV2
(function( o, $, json, h ){
  if( !o || !$ || !json || !h ) return false;

  $('main').addClass('sta-init-space');

  var createImg = function( obj ){
    var alt = obj.text ? nameHotel + obj.text : nameHotel + obj.zone + ' '+ (obj.posi+1),
    str = '<div class="sta-gallery-air_sideboard-element" tabindex="0">' +
      '<div class="sta-gallery-air_sideboard-element-wrapper">' +
        '<a href="'+obj.imgG+'" aria-label="'+alt+'" data-lightbox="' + obj.zone + '">' +
          '<figure class="sta-gallery-air_sideboard-element-photo" data-lazyimg="'+obj.imgP+'" role="img" aria-label=""></figure>' +
        '</a>' +
      '</div>' +
    '</div>';
    return str;
  },
  nameHotel = window.dataSeo && dataSeo.hotel && dataSeo.hotel.name && dataSeo.hotel.name.trim() ? dataSeo.hotel.name.trim() + ' - ' : '',
  $clone = $( o.querySelector('.sta-bckp') ).clone().removeClass('sta-bckp'),
  $content = $( o.querySelector('.sta-gallery-air_highlights') );

  $( o.querySelector('.sta-bckp') ).remove();

  //evitar bug de slick
  (function() {
    var arr = [];
    for (var i = 0; i < json.length; i++) {
      if(json.length && json[i].photos.length){
        while (json[i].photos.length < 7) {
          json[i].photos = json[i].photos.concat( json[i].photos );
        }
      } else {
        arr.push(json[i]);
      }
    }
    for (var i2 = 0; i2 < arr.length; i2++) json.splice( json.indexOf(arr[i2]) , 1);
  })();

  //multigalery
  for (var i = 0; i < json.length; i++) {
    (function( zona ){
      var $html = $clone.clone();
      if( zona.id ) $html.addClass('scroll-anchor_'+zona.id);
      $('.sta-gallery-air_sideboard-header-title',$html).text( zona.name ),
      $contentImg = $('.sta-gallery-air_sideboard-list-container',$html);

      for (var i2 = 0; i2 < zona.photos.length; i2++) {
        $contentImg.append( createImg( { zone : encodeURI( zona.name ), imgG : zona.photos[i2].url, imgP : zona.photos[i2].url, text : zona.photos[i2].name, posi:i2 } ) );
      };

      $content.append( $html );
    })( json[i] );
  };

  loadScript('/templates/cadenas/air/js/gallery.js',new Function);

})( document.querySelector('.fn-galleryV2'), window.jQuery, window.json_multiGalerias, window.hotusa && hotusa() );

//create html galleryV3
(function( o, $, json, h ){
  if( !o || !$ || !json || !h ) return false;

  $( document.querySelector('.tgl-internbar-air') ).addClass('sta-desktop-static');

  var createImg = function( obj ){
    var alt = obj.text ? nameHotel + obj.text : nameHotel + obj.zone + ' '+ (obj.posi+1),
    str = '<div class="sta-gallery-air_sideboard-element" tabindex="0" data-zone="' + obj.zone + '">' +
      '<div class="sta-gallery-air_sideboard-element-wrapper">' +
        '<a href="'+obj.imgG+'" aria-label="'+alt+'" data-lightbox="all">' +
          '<figure class="sta-gallery-air_sideboard-element-photo" data-lazyimg="'+obj.imgP+'" role="img" aria-label=""></figure>' +
        '</a>' +
      '</div>' +
    '</div>';
    return str;
  },
  nameHotel = window.dataSeo && dataSeo.hotel && dataSeo.hotel.name && dataSeo.hotel.name.trim() ? dataSeo.hotel.name.trim() + ' - ' : '',
  $content = $( o.querySelector('.sta-gallery-air_sideboard-list-container') );

  //multigalery
  for (var i = 0; i < json.length; i++) {
    (function(zona, nameZone){
      for (var i2 = 0; i2 < zona.photos.length; i2++) {
        $content.append( createImg( { zone : nameZone, imgG : zona.photos[i2].url, imgP : zona.photos[i2].url, text : zona.photos[i2].name,posi:i2 } ) );
      };
    })( json[i], encodeURI(json[i].name) );
  };

  loadScript('/templates/cadenas/air/js/gallery.min.js',new Function);

})( document.querySelector('.fn-galleryV3'), window.jQuery, window.json_multiGalerias, window.hotusa && hotusa() );

//create html internbar in gallery
(function( o, $, json ){
  if( !o || !$ || !json ) return false;

  var $o = $(o),
  createLi = function(obj){
    //obj = {text : "Habitacion", zone : "room", video:"asda"}

    if( obj.zone ) return '<div class="sta-internbar-air_links-element js-filter-gallery" data-zone_selector="' + obj.zone + '" role="button" tabindex="0"><h2 class="sta-internbar-air_element-text">' + obj.text + '</h2></div>';
    if( obj.video ) return '<div class="sta-internbar-air_links-element js-video-gallery" data-video="https://www.youtube.com/embed/' + obj.video + '" role="button" tabindex="0"><h2 class="sta-internbar-air_element-text">' + copyVideo + '</h2></div>';
    if( obj.videoW ) return '<div class="sta-internbar-air_links-element js-video-gallery" data-video="https://fast.wistia.net/embed/iframe/' + obj.videoW + '" role="button" tabindex="0"><h2 class="sta-internbar-air_element-text">' + copyVideo + '</h2></div>';
  },
  $contentLinks = $( o.querySelector('.sta-internbar-air_links') ),
  copyVideo = $o.data('traduvideo');

  for (var i = 0; i < json.length; i++) {
    if( json_multiGalerias[i].video || json_multiGalerias[i].videoW ){
      $contentLinks.append( createLi( { video : json_multiGalerias[i].video, videoW : json_multiGalerias[i].videoW } ) );
    } else {
      $contentLinks.append( createLi( { text : json[i].name, zone : encodeURI(json_multiGalerias[i].name) } ) );
    }
  };

  $o.removeClass('staOculto');

})( document.querySelector('.fn-internbarGallery'), window.jQuery, window.json_multiGalerias );

//create html carrusel
(function( json, $ ){
  if( !json || !$ ) return false;
  var createDivs = function( arr ){
    var str = '';
    for (var i = 0; i < arr.length; i++) {
      str += "<div class='sta-carousel-air_multimedia-element'>" +
        "<figure class='sta-carousel-air_multimedia-photo' role='img' aria-label='' data-lazyimg='" + arr[i].url + "'></figure>" +
      "</div>";
    };
    return str;
  }
  for (var i = 0; i < json.length; i++) {
    (function( elem ){
      var $o = $( document.querySelectorAll('.'+elem.o) );
      if( !$o.length || !elem.imgs.length ) return false;
      $o.html( createDivs(elem.imgs) );
    })( json[i] );
  };
})( window.json_carrusel, window.jQuery );

//create html slate lineal
(function( json, $ ){
  if( !json || !$ ) return false;
  var createDivs = function( arr, galleryID ){
    var str = '',
    alt = window.dataSeo && dataSeo.hotel && dataSeo.hotel.name && dataSeo.hotel.name.trim() ? (dataSeo.hotel.name.trim() + ' - ') : '';
    alt += 'Gallery ';

    for (var i = 0; i < arr.length; i++) {
      str += "<div class='sta-slate-air_element'>"
        + "<div class='sta-slate-air_element-box'>"
          + "<a href='"+arr[i].url+"' aria-label='"+alt+(i+1)+ "' data-lightbox='gallery"+galleryID+"'>"
            + "<div class='sta-slate-air_element-multimedia'>"
              + "<figure class='sta-slate-air_multimedia-photo' role='img' aria-label='' data-lazyimg='"+arr[i].url+"'></figure>"
            +" </div>"
          + "<div class='sta-slate-air_element-info'>";

      if( arr[i].name && arr[i].name.trim() ) str += "<p class='sta-slate-air_info-title'>"+arr[i].name+"</p>";
      
      str += "</div></a></div></div>";
    };
    return str;
  }
  for (var i = 0; i < json.length; i++) {
    (function( elem ){
      var $o = $( document.querySelectorAll('.'+elem.o) );
      if( !$o.length || !elem.imgs.length ) return false;
      $o.html( createDivs(elem.imgs, elem.o.split('_')[1]) );
    })( json[i] );
  };
})( window.json_slateLineal, window.jQuery );

//create html slate Cuadrado
(function( json, $ ){
  if( !json || !$ ) return false;
  var createDivs = function( arr, galleryID ){
    var str = '',
    alt = window.dataSeo && dataSeo.hotel && dataSeo.hotel.name && dataSeo.hotel.name.trim() ? (dataSeo.hotel.name.trim() + ' - ') : '',
    initColumn = true,
    par = false,
    resto = arr.length % 2;
    alt += 'Gallery ';

    for (var i = 0; i < arr.length; i++) {

      if( initColumn && par ){
        par = false;
        str += "<div class='sta-slate-air_element sta-impar'>"
      } else if( initColumn ){
        par = true;
        str += "<div class='sta-slate-air_element sta-par'>";
      };

      //last
      if( arr.length-1 == i && !!resto ) str += "<div class='sta-slate-air_element-box sta-lastImage_"+resto+"'>";
      //default
      else str += "<div class='sta-slate-air_element-box'>";

      str += "<a href='"+arr[i].url+"' aria-label='"+alt+(i+1)+ "' data-lightbox='gallery"+galleryID+"'>"
      + "<div class='sta-slate-air_element-multimedia'>"
      + "<figure class='sta-slate-air_multimedia-photo' role='img' aria-label='' data-lazyimg='" + arr[i].url + "'></figure>"
      + "</div>"
      + "<div class='sta-slate-air_element-info'>";

      if( arr[i].name && arr[i].name.trim() ) str += "<p class='sta-slate-air_info-title'>"+arr[i].name+"</p>";

      str += "</div></a></div>";

      if( !initColumn ) str += "</div>";

      initColumn = !initColumn;
    };

    if( initColumn ) str += "</div>";

    return str;
  }
  for (var i = 0; i < json.length; i++) {
    (function( elem ){
      var $o = $( document.querySelectorAll('.'+elem.o) );
      if( !$o.length || !elem.imgs.length ) return false;
      $o.html( createDivs(elem.imgs, elem.o.split('_')[1]) );
    })( json[i] );
  };
})( window.json_slateCuadrado, window.jQuery );



//create html slate Mosaico
(function( json,$ ){
  if( !json || !$ ) return false;
  var createDivs = function( arr ){
    var str = '',
    alt = window.dataSeo && dataSeo.hotel && dataSeo.hotel.name && dataSeo.hotel.name.trim() ? (dataSeo.hotel.name.trim() + ' - ') : '',
    initColumn = true,
    resto = arr.length % 3,
    par = false,
    endColumn = false;
    alt += 'Gallery ';

    for (var i = 0; i < arr.length; i++) {
      initColumn = i % 3 == 0;
      endColumn = (i+1) % 3 == 0;

      if( initColumn && par ){
        par = false;
        str += "<div class='sta-slate-air_element sta-impar'>"
      } else if( initColumn ){
        par = true;
        str += "<div class='sta-slate-air_element sta-par'>";
      };

      //last
      if( arr.length-1 == i && !!resto ) str += "<div class='sta-slate-air_element-box sta-lastImage_"+resto+"'>";
      //penultimate
      else if( arr.length-2 == i && !!resto ) str += "<div class='sta-slate-air_element-box sta-penulImage_"+resto+"'>";
      //default
      else str += "<div class='sta-slate-air_element-box'>";

      str += "<a onclick=\"crearGaleria('" + arr[i].url + "')\" aria-label='" + alt + (i + 1) + "'>"
      + "<div class='sta-slate-air_element-multimedia'>"
      + "<figure class='sta-slate-air_multimedia-photo' role='img' aria-label='' data-lazyimg='" + arr[i].url + "'></figure>"
      + "</div>"
      + "<div class='sta-slate-air_element-info'>";

      if( arr[i].name && arr[i].name.trim() ) str += "<p class='sta-slate-air_info-title'>"+arr[i].name+"</p>";

      str += "</div></a></div>";

      if( endColumn ) str += "</div>";

    };

    if( endColumn ) str += "</div>";

    return str;
  }
  for (var i = 0; i < json.length; i++) {
    (function( elem ){
      var $o = $( document.querySelectorAll('.'+elem.o) );
      if( !$o.length || !elem.imgs.length ) return false;
      $o.html( createDivs(elem.imgs) );
    })( json[i] );
  };
})( window.json_slateMosaico, window.jQuery );



var putCoverArrow =(function(cover, alertas, $){
  if( !cover || !$ ) return new Function();
  //altura alertas
  return function(){
    var h_total = (window.innerWidth < 1024) ? 70 : 0;
    // if(!alertas.length) return h_total; 
    for (var i = 0; i < alertas.length; i++){
      if($(alertas[i]).css('display') !== 'none'){
        h_total += $(alertas[i]).outerHeight();
      }
    }
    //damos altura
    $(cover).css('min-height','calc(100vh - ' + h_total + 'px)');
  };
  
})( document.querySelector('.tgl-cover-air'), document.querySelectorAll('.tgl-avisos-air'), window.jQuery );

(function ( o,m,$ ) {
  if( !o || !m || !$ ) return false;

  $(m).addClass('sta-logoOff_top');
  
})( document.querySelector('.tgl-cover-air.sta-logo_center'), document.querySelector('.tgl-menus-air.sta-logo-center'), window.jQuery );

//class with internabar
(function( o, m, $){
  if( !o || !m || !$ ) return false;

  if( !o.querySelector('.sta-internbar-air_links .sta-internbar-air_links-element') ){
    o.remove()
    return false;
  };

  // $(m).addClass('sta-init-space sta-internbar-space-responsive');
})( document.querySelector('.tgl-internbar-air'), document.querySelector('main'), window.jQuery );

//first module
(function( m, $){

  var arr = [
    'main.global-container > .tgl-breadcrumbs-air:first-child',
    'main.global-container > .tgl-devicesheader-air:first-child + .tgl-breadcrumbs-air',
    'main.global-container > .tgl-intro-air:first-child',
    'main.global-container > .tgl-devicesheader-air:first-child + .tgl-intro-air',
    'main.global-container > .tgl-cardpage-air:first-child',
    'main.global-container > .tgl-devicesheader-air:first-child + .tgl-cardpage-air',
    'main.global-container > .tgl-carousel-air:first-child',
    'main.global-container > .tgl-devicesheader-air:first-child + .tgl-carousel-air',
    'main.global-container > .tgl-enginepage-air:first-child',
    'main.global-container > .tgl-devicesheader-air:first-child + .tgl-enginepage-air',
    'main.global-container > .tgl-internbar-air:first-child',
    'main.global-container > .tgl-devicesheader-air:first-child + .tgl-internbar-air',
    'main.global-container > .linkComprarBonos:first-child',
    'main.global-container > .tgl-devicesheader-air:first-child + .linkComprarBonos',
    'main.global-container > .tgl-bonoForm:first-child',
    'main.global-container > .tgl-devicesheader-air:first-child + .tgl-bonoForm',
    'main.global-container > .tgl-bonoConfirm:first-child',
    'main.global-container > .tgl-devicesheader-air:first-child + .tgl-bonoConfirm',
    'main.global-container > .tpl-voucher-confirmation:first-child',
    'main.global-container > .tgl-devicesheader-air:first-child + .tpl-voucher-confirmation',
    'main.global-container > .tgl-motor-air:first-child',
    'main.global-container > .tgl-devicesheader-air:first-child + .tgl-motor-air',
    'main.global-container > .tgl-missingYou:first-child',
    'main.global-container > .tgl-devicesheader-air:first-child + .tgl-missingYou',
  ];

  if( !document.querySelector( arr.join(',') ) || !m || !$ ) return false;

  $(m).addClass('sta-init-space');

})( document.querySelector('main.global-container'), window.jQuery );

// regular tamaño de small footer
(function(m, f){
  if(!m || !f ) return false;

  var minHeight = function(){
    m.style.minHeight = 'calc(100vh - ' + f.clientHeight + 'px)';
  };
  
  minHeight();
  window.addEventListener('resize', minHeight);

})( document.querySelector('main'), document.querySelector('footer') );

// cardpage
(function( a, $){
  if( !a.length || !$ ) return false;

  var ev = function(o){

    var classNotImg = $(o).hasClass('sta-notImg'),
    imgCont = o.querySelector('.sta-cardpage-air_multimedia'),
    img = $( imgCont.querySelector('.sta-cardpage-air_multimedia-photo') ).data('lazyimg'),
    cert = o.querySelector('.sta-cardpage-air_certificates'),
    timeInput = o.querySelector('.sta-input input[type=time]'),
    dateInput = o.querySelector('.sta-input input[type=date]');

    if( classNotImg || !img ){
      imgCont.remove();
      $(o).addClass('sta-notImg');
    };
    
    if( !cert ) return false;
    
    var cert_child = cert.querySelectorAll('.sta-cardpage-air_certificates-element');
    for (var i = 0; i < cert_child.length; i++) {
      (function( elem ){
        var $a = $(elem.querySelector('a'));
        if( !$a.attr('href').trim() ) $( elem ).html( $a.html() );
      })( cert_child[i] );
    };
    if( timeInput ){
      timeInput.addEventListener('focus', function(){
        this.showPicker();
      },false);
    }
    if( dateInput ){
      dateInput.addEventListener('focus', function(){
        this.showPicker();
      },false);
    }
  };

  for (var i = 0; i < a.length; i++) ev(a[i]);

})( document.querySelectorAll('.tgl-cardpage-air'), window.jQuery );


//formJson
(function (form, h, array) {
  if (!form || !h) return false;

  if (!Array.isArray(array) || !array.length) {
    console.trace('ERROR: Json is not defined', array);
    return false;
  }

var valid = function () {
  var send = true,
    e_empty = false,
    e_mail = false,
    e_poli = false;

  obj.error.o.textContent = '';
  obj.error.o.classList.remove('invalid', 'ok');

  //obligatorios
  for (var i = 0; i < obj.oblig.length; i++) {
    if (!obj.oblig[i].value.trim()) {
      obj.oblig[i].parentElement.classList.add('invalid')
      send = false;
      e_empty = true;
    } else {
      obj.oblig[i].parentElement.classList.remove('invalid');
    }
  };

  //emails
  for (var i = 0; i < obj.emails.length; i++) {
    if (!h.mail(obj.emails[i].value.trim())) {
      obj.emails[i].parentElement.classList.add('invalid')
      send = false;
      e_mail = true;
    } else {
      obj.emails[i].parentElement.classList.remove('invalid')
    }
  }

  //politic
  if (!obj.politic.checked) {
    obj.politic.parentElement.classList.add('invalid')
    send = false;
    e_poli = true;
  } else {
    obj.politic.parentElement.classList.remove('invalid')
  };

  if (e_empty) obj.error.o.appendChild(obj.error.empty);
  if (e_mail) obj.error.o.appendChild(obj.error.mail);
  if (e_poli) obj.error.o.appendChild(obj.error.poli);

  if (!send) {
    obj.error.o.classList.add('sta-error', 'sta-cardpage-air_warning-text');
    obj.error.o.classList.remove('fn-hide');
    processEnvio = false;
  }

  return send;

},
  enviar = function () {
    var datos = {
      d: {
        hotel: window.dataSeo && dataSeo.hotel && dataSeo.hotel.name ? dataSeo.hotel.name : '',
        url: location.origin + location.pathname,
        text: '',
        personal_inf: null
      }
    };

    if (window.getComputedStyle(obj.personalInf.parentElement).display == 'none') {
      datos.d.personal_inf = 'Not available';
    } else {
      datos.d.personal_inf = obj.personalInf.checked ? 'yes' : 'no';
    }


    for (var i = 0; i < obj.allElements.length; i++) {
      datos.d.text += '<b>' + obj.allElements[i].text + ' : </b>' + obj.allElements[i].o.value;
      if (i < obj.allElements.length - 1) datos.d.text += '<br>';
    }
    if (recaptcha) {
      grecaptcha.ready(function () {
        grecaptcha.execute(recaptcha, { action: 'sendForm' }).then(function (token) {
          ajax(datos);
        });
      });
    } else {
      ajax(datos);
    };
  },
  ajax = function (datos) {
    var _tmp = {
      url: url,
      data: JSON.stringify(datos),
      type: 'POST',
      success: function (e) {
        if (e === "OK") {
          obj.error.o.appendChild(obj.error.ok);
          obj.error.o.classList.add('sta-cardpage-air_done-text');
          obj.error.o.classList.remove('fn-hide');
          //reset
          form.reset();
        }
        processEnvio = false;
      },
      error: function (e) {
        console.trace('ERROR: Fail form', e);
        processEnvio = false;
      }
    };
    h.ajax(_tmp);
  },
  // event 
  eventInputTextarea = function (elem, email, divInput) {
    elem.addEventListener("change", function () {
      var val = this.value.trim();
      email && !h.mail(val) || !val
        ? divInput.classList.add('invalid')
        : divInput.classList.remove('invalid');
    });
  },

  recaptcha = form.dataset.recaptcha,
  url = (function (pathname) {
    if (pathname.slice(-1) == '/') return pathname + 'form.html';
    return pathname.replace('.html', '/form.html')
  })(window.location.pathname),
  processEnvio = false,
  obj = {
    politic: form.policy,
    personalInf: form.acept_mail,
    allElements: [],
    oblig: [],
    emails: [],
    error: {
      o: form.querySelector('ul.sta-error'),
      empty: document.createElement('li'),
      mail: document.createElement('li'),
      ok: document.createElement('li'),
      poli: document.createElement('li')
    }
  };
  (function () {
    obj.error.empty.innerText = form.copyEmpty.value;
    obj.error.mail.innerText = form.copyEmail.value;
    obj.error.poli.innerText = form.copyPoliticas.value;
    obj.error.ok.innerText = form.copyOk.value;
  })();

  (function (insert) {
    for (var i = 0; i < array.length; i++) {
      (function (_obj) {
        var divPrins = document.createElement('div'),
          divInput = document.createElement('div'),
          elem;

        divPrins.className = 'sta-cardpage-air_form-element';

        if (_obj.type === 'textarea') {
          elem = document.createElement('textarea');
          elem.className = 'sta-textarea-field textColor textGC';
          divInput.className = 'sta-textarea';

        } else {
          elem = document.createElement('input');
          elem.className = 'sta-input-field textColor textGC';
          elem.type = _obj.type ? _obj.type : 'text';

          switch (_obj.type) {
            case 'date':
              elem.max = _obj.max ? _obj.max : '2123-12-31';
              elem.min = _obj.min ? _obj.min : '1823-12-31';
              elem.addEventListener('focus', function () {
                this.showPicker();
              });
              break;
            case 'time':
              elem.addEventListener('focus', function () {
                this.showPicker();
              });
              break;
            case 'email':
              obj.emails.push(elem);
              break;
          }
          divInput.className = _obj.class ? 'sta-input ' + _obj.class : 'sta-input';
        }

        if (_obj.type == 'date' || _obj.type == 'time') {
          var span = document.createElement('span');
          span.className = 'sta-time';
          span.setAttribute('data-text', _obj.text);
          if (_obj.oblig) span.dataset.text = _obj.text + '*'
          divInput.append(span);
        }
        if (_obj.text) {
          elem.placeholder = _obj.oblig ? _obj.text + '*' : _obj.text;
        }
        divInput.append(elem);
        divPrins.append(divInput);
        insert.append(divPrins);

        obj.allElements.push({ o: elem, text: _obj.text })
        if (_obj.oblig) {
          obj.oblig.push(elem);
          elem.required = true;
          eventInputTextarea(elem, _obj.type == 'email', divInput);
        }

      })(array[i]);
    }

  })(document.querySelector('.sta-cardpage-air_list'))


  form.addEventListener('submit', function (event) {
    event.preventDefault();

    if (processEnvio) return false;

    processEnvio = true;
    if (valid()) enviar();
  }, false);

  if (recaptcha) h.cargaScrollAuto({ obj: form }, function () {
    h.cargarFicheroJS('https://www.google.com/recaptcha/api.js?render=' + recaptcha);
  });


})(document.querySelector('.formJson'), window.hotusa && hotusa(), window.formJson);


//class ventajas resto
(function( a, $, h ){
  if( !a.length || !$ || !h ) return false;

  var ev = function (o) {
    var n = o.querySelectorAll('.advice-list .advice-list-element').length,
    a = o.querySelectorAll('.sta-advice-air_enlace');

    switch (n) {
      case 1:
      case 2:
      case 3:
      case 4:
        $(o).addClass('sta-exact_'+n);
        break;
        
      default:

        if( n % 4 == 0 ){
          $(o).addClass('sta-exact_4');
        } else if( n % 3 == 0 ){
          $(o).addClass('sta-exact_3');
        } else if( n % 4 > n % 3 ) {
          $(o).addClass('sta-exact_4')
        } else {
          $(o).addClass('sta-exact_3');
        }

        break;
    };

    for (var i = 0; i < a.length; i++) {
      h.enlace_blank( $( a[i] ) );
    }
  };

  for(var i = 0; i < a.length; i++) ev( a[i] );

})( document.querySelectorAll('.tgl-advice-air'), window.jQuery, window.hotusa && hotusa() );

//enlaces pdfs in intro
(function( o,$,h ){
  if( !o || !$ || !h ) return false;

  var a = o.querySelector('.sta-intro-air_btn');
  if( a ) h.enlace_blank( $(a) );
})( document.querySelector('.tgl-intro-air'), window.jQuery, window.hotusa && hotusa() );

//enlaces pdfs in carousels
(function( a,$,h ){
  if( !a.length || !$ || !h ) return false;

  var ev = function (o) {
    var as = o.querySelectorAll('.sta-carousel-air_info-btn,.sta-btn-moreinfo');
    for (var i = 0; i < as.length; i++) h.enlace_blank( $(as[i]) );
  };

  for (var i = 0; i < a.length; i++) ev(a[i]);

  h.cargaScrollAuto({ obj : a[0],dual:true}, function(){
    var link = document.createElement('link');
    link.rel = "stylesheet";
    link.href = "/css/style_icons_services_banderas.min.css";
    $('head').append(link);
  });

})( document.querySelectorAll('.tgl-carousel-air'), window.jQuery, window.hotusa && hotusa() );

//enlaces pdf footer
(function( o,$,h ){
  if( !o || !$ || !h ) return false;

  var as = o.querySelectorAll('.sta-staticfoot-air_element-wrapper');

  for (var i = 0; i < as.length; i++) h.enlace_blank( $( as[i] ) );

})( document.querySelector('.tgl-staticfoot-air'), window.jQuery, window.hotusa && hotusa() );

//mapaweb
(function( o,$,h ) {
  if( !o || !$ || !h ) return false;
  var elems = o.querySelector('.sta-cardpage-air_dropdowns').children;

  for (var i = elems.length-1; i >= 0; i--)
    if( elems[i].querySelector('a').href.slice(0,10) == "javascript" ) elems[i].remove();

})( document.querySelector('.tgl-cardpage-air.sta-mapaweb'), window.jQuery, window.hotusa && hotusa() );

//open cookies
(function(a,inp,conf,$){
  if( !a.length || !inp || !conf || !$ ) return false;
  var $scroll = $('html'),
  open = function(){
    inp.checked = false;
    $scroll.addClass('sta-noScroll')
  },
  ev = function( $b ){
    var boo = $b.hasClass('fn-confCookies');
    $b.click(function(e){
      e.preventDefault();
      conf.checked = boo;
      open();
    });
  };

  for (let i = 0; i < a.length; i++) ev( $(a[i]) );

})( document.querySelectorAll('.fn-openCookies'), document.getElementById('sta-cookies'), document.getElementById('sta-cookies_config'), window.jQuery );

(function( a,$,h ) {
  if( !a.length || !$ || !h ) return false;

  var dom = location.origin + location.pathname,
  controlA = function ($a,remove) {
    if( $a.attr('href') == dom ) remove.remove();
  },
  controlPrice = function( content, $o ){
    if( content && content.textContent.trim().length > 7 ){
      $o.addClass('sta-priceSmall');
      return true;
    } else {
      return false;
    };
  },
  ev = function (o) {
    var a = o.querySelector('header .sta-btn-moreinfo'),
    content = o.querySelector('.sta-products-air_content');
    
    if( !a || !content )return false;

    var elems = content.children;

    //link ver mas
    controlA( $(a), a );
    for (var i = 0; i < elems.length; i++){
      (function(product) {
        controlA( $(product.querySelector('.sta-products-air_btns-element')), product);
        h.enlace_blank( $( product.querySelector('.sta-products-air_btns-element') ) );
        h.enlace_blank( $( product.querySelector('.sta-products-air_element-wrapper a') ) );
      })(elems[i]);
    }

    for (var i = 0; i < elems.length; i++){
      if( controlPrice( elems[i].querySelector('.sta-products-air_price-number'), $(o) ) ){ break }
    }
    
    //elements
    var data = $(o).data();

    if( data.slides_tablet && data.slides_tablet > elems.length ) $(o).attr('data-slides_tablet',elems.length);
    if( data.slides_pc && data.slides_pc > elems.length ) $(o).attr('data-slides_pc',elems.length);

  };

  for (var i = 0; i < a.length; i++) ev(a[i]);

})( document.querySelectorAll('.tgl-products-air'), window.jQuery, window.hotusa && hotusa());

(function (o) {
  if (!o || window.innerWidth > 800) return false;
  window.document.dispatchEvent(new CustomEvent('showModalEngine'));
})(document.querySelector('.tgl-enginepage-air'));

(function( o,$ ){
  if( !o || !$ ) return false;

  var children = o.children,
  ev = function (o) {
    var modal = o.querySelector('.tgl-infopop-air'),
    nDistribuciones = modal.querySelector('.sta-infopop-air_services').childElementCount;
    if( !nDistribuciones ){
      modal.remove();
      o.querySelector('.sta-carousel-air_info-btn').remove();
    };
  };

  for (var i = 0; i < children.length; i++) ev( children[i] );

})( document.querySelector('.tgl-meetinglist-container'), window.jQuery );

(function( a,$ ){
  if( !a.length || !$ ) return false;

  var ev = function(o){
    var imgs = o.querySelectorAll('.sta-slate-air_element a');
    for (var i = 0; i < imgs.length; i++) {
      (function ( $img ) {
        $img
        .removeAttr('data-lightbox')
        .attr('href','')
        .click(function(e){
          e.preventDefault();
        });
      })( $( imgs[i] ) );
      
    }
  };

  for (var i = 0; i < a.length; i++) ev(a[i]);

})( document.querySelectorAll('.tgl-slate-air.sta-notModal'), window.jQuery );

(function( o,$,h ){
  if( !o || !$ || !h ) return false;

  var awards = o.querySelector('.sta-linksfoot-air_element-awards');

  if( awards ){
    var elems = awards.children;
    for (var i = 0; i < elems.length; i++) {
      (function( $a ){
        $a.attr('href')
        ? h.enlace_blank( $a )
        : $a.replaceWith( $('<div></div>').html( $a.html() ) );
      })( $( elems[i] ) );
    }
  };

  var lista = o.querySelector('.sta-linksfoot-air_list');

  if( lista ){
    var elem = lista.children; 
    for (var j = 0; j < elem.length; j++) 
      h.enlace_blank( $( elem[j].querySelector('a') ) );
  }

  if( lista.children.length == 3 ) $(o).addClass('sta-children3');
  
})( document.querySelector('.tgl-linksfoot-air'), window.jQuery, window.hotusa && hotusa() );

(function(a, $, h) {
  if( !a.length || !$ || !h ) return false;

  var $p = $(a[0]).parent();
  
  $p.attr('alertas', a.length);

  var close = function( $o, time ){
    clearTimeout(time);
    $o.slideUp(1e3,function() {
      $p.attr('alertas', parseInt($p.attr('alertas')) - 1 )
      if(window.putCoverArrow) putCoverArrow();
    });
  };

  for (var i = 0; i < a.length; i++) {
    (function(o) {
      var $o = $(o),
      timeout = null,
      seconds = $o.data('seconds'),
      appear = $o.hasClass('sta-notAppear'),
      appearId = $o.data('id');

      if(appear && h.getSessionStorageJSON(appearId) ){
        $o.hide();
        return false;
      }

      if( seconds && !isNaN(seconds) ) timeout = setTimeout(function(){ close( $o, timeout ) }, parseInt(seconds*1000));

      if( !$o.hasClass('sta-notClose') ){
        $( o.querySelector('.sta-avisos-air_close') ).on('click', function(){
          if(appear) h.setSessionStorageJSON(appearId,true);
          
          $(this).off('click');
          close( $o, timeout );
        });
      }

    })(a[i])
  };

  if(window.putCoverArrow) putCoverArrow();

})(document.querySelectorAll('.tgl-avisos-air'), window.jQuery, window.hotusa && hotusa());

(function(o,$,h,json,seo) {
  if( !o || !$ || !h || !json || !seo || !seo.opinions || !seo.hotel || !seo.hotel.name ) return false;

  var cuentaAtras = function(obj,time,decimal){
    decimal = !decimal ? false : true;
    var intervalo = 100,
    incr = obj.n/(time/intervalo);
    obj.inc = incr;
    var t = setInterval(function(){
      obj.html.innerHTML = decimal ? obj.inc.toFixed(1) : parseInt(obj.inc);
      if(obj.inc > obj.n){
        obj.html.innerText = obj.n;
        clearInterval(obj.t);
      } else {
        obj.inc += incr;
      };
    },intervalo);
    obj.t = t;
  },
  fns = [function(){
    $(o).addClass('sta-active');
  }],
  circle = $(o).hasClass('sta-circle');

  if( json.fondo ){
    var img = new Image(),
    $bkc = $( o.querySelector('.sta-viewSmall-air_bck') );

    img.src = json.fondo;
    img.onload = function(){
      $bkc.css('background-image',"url('"+img.src+"')")
    };
    img.onerror = function(e){
      console.trace('Error image: ',e);
    };
  };
  if( seo.opinions.nota ){
    (function(note){
      fns.push(function(){
        cuentaAtras({html:note,n:seo.opinions.nota},3e3,true);
      });
      if( circle ) $( o.querySelector('.sta-viewSmall-air_points .sta-viewSmall-air_circle .circle') ).attr('stroke-dasharray',seo.opinions.nota*10+', 100');
    })(o.querySelector('.sta-viewSmall-air_points .sta-num'));
  };
  if( seo.opinions.recommend ){
    (function(note){
      fns.push(function(){
        cuentaAtras({html:note,n:seo.opinions.recommend},3e3);
      });
      if( circle ) $( o.querySelector('.sta-viewSmall-air_recommend .sta-viewSmall-air_circle .circle') ).attr('stroke-dasharray',seo.opinions.recommend+', 100');
    })(o.querySelector('.sta-viewSmall-air_recommend .sta-num'));
  };
  if( json.logos && json.logos.length ){
    var $cont = $( o.querySelector('.sta-viewSmall-air_banner') ),
    text = o.querySelector('.sta-viewSmall-air_puntuacion .sta-viewSmall-air_text').textContent;

    $(o).addClass('sta-banner');

    for (var i = 0; i < json.logos.length; i++) {
      (function( obj, posi ){
        var img = new Image(),
        $img = $('<img />',{ alt : obj.name ? obj.name : text+' - '+seo.hotel.name+' - '+(posi+1) });

        $cont.append( $img );

        img.src = obj.url;

        img.onload = function(){
          $img.attr('src',this.src);
        };
        img.onerror = function(e){
          $img.remove();
          console.trace('Error load image:',e);
        };
      })( json.logos[i], i );
    }
  }

  h.cargaScrollAuto({obj:o,before:300,dual:true},function(){
    for (var i = 0; i < fns.length; i++) fns[i]();
  })
  
})(document.querySelector('.tgl-viewSmall-air'), window.jQuery, window.hotusa && hotusa(), window.json_viewSmall, window.dataSeo);

(function(o, $) {
  if(!o || !$) return false;

  var rooms = o.querySelectorAll('.tgl-carousel-air'),
  classP = $(o).hasClass('sta-room'),
  roomIndi = function(r) {
    r.querySelector('.tgl-infopop-air').remove();
    var $btn = $(r.querySelector('.sta-carousel-air_info-btn.sta-btn-moreinfo')),
    url = $btn.data('urlindividual');
    if(url){
      $btn.on('click',function() {
        window.location.href = url;
      })
    }
  }

  for (var i = 0; i < rooms.length; i++) {
    (function(room) {
      if( classP || $(room).hasClass('sta-room') ) roomIndi(room);
    })(rooms[i]);
  }

})(document.querySelector('.tgl-roomslist-container'),window.jQuery);


(function( o ) {
  if( !o ) return false;

  if( document.querySelector('.sta-mainDispo') ){
    o.remove()
    return false;
  }
})( document.querySelector('.tgl-socialRedes-air') );


// keypress enter buttons
(function (a, $) {
  if (a.length) {
    for (var i = 0; i < a.length; i++) {
      var btn = a[i];
      btn.addEventListener("keyup", function (event) {
        if (event.keyCode === 13) {
          $(this).click();
        }
      });
    }
  };
})(document.querySelectorAll('[tabindex="0"]'), jQuery);

// load js file
function loadScript(url, callback) {
  hotusa().cargarFicheroJS(url,callback);
  // var script = document.createElement('script');
  // script.onload = function () {
  //   callback();
  // };
  // script.src = url;
  // document.head.appendChild(script);
};

// load css file
function loadStyle(url) {
  var link = document.createElement("link");
  link.href = url;
  link.type = "text/css";
  link.rel = "stylesheet";
  link.media = "screen,print";
  document.getElementsByTagName("head")[0].appendChild(link);
}

// if element is visible
function isScrolledIntoView(el, distance) {
  var rect = el.getBoundingClientRect(),
    elemTop = rect.top - distance,
    elemBottom = rect.bottom,
    isVisible = elemTop < window.innerHeight;
  return isVisible;
}

$(document).ready(function () {
  // function ladyload images
  var load_imgs = (function(){
    var alt = window.dataSeo && dataSeo.hotel && dataSeo.hotel.name && dataSeo.hotel.name.trim() ? dataSeo.hotel.name.trim() + ' - ' : 'Gallery - ',
    n = 1,
    firstImg = false,
    fn = function(object){
      for (var i = 0; i < object.length; i++) {
        var element = object[i],
        image = element.dataset.lazyimg,
        visibility = element.offsetWidth > 0 || element.offsetHeight > 0;

        if( !firstImg && window.crearDatosExtructurados ){
          firstImg = true;
          crearDatosExtructurados( image );
        };

        if (image && isScrolledIntoView(element, 300) && visibility) {
          if (element.tagName == 'IMG') {
            element.setAttribute('src', image);
          } else {
            $(element)
            .css('background-image','url("' + image + '")')
            .append( $('<img />',{src:image, class:"imgOcultaAda",alt:alt + n}) );
            n++;
          }
          //remove in array
          element.removeAttribute('data-lazyimg');
        }
      }
    }
    return fn;
  })();

  //header motor
  (function ( o,m,hide,$ ) {
    if( !o || !$ ) return false;

    if( !m || hide ){
      $(o).addClass('sta-motorRedirect');
    } else {
      $(o).addClass('sta-motorScroll');
      var btns = o.querySelectorAll('.sta-menus-air_nav-action .sta-scroll-book,.sta-menus-air_nav-action-aside .sta-scroll-book'),
      $scroll = $(btns[0]).data('scroll_to') && document.querySelector($(btns[0]).data('scroll_to')) ? $(document.querySelector($(btns[0]).data('scroll_to'))) : false,
      spacer = $(btns[0]).data('scroll_spacer') ? $(btns[0]).data('scroll_spacer') : 0;
      
      $(btns).click(function () {
        if( !$('#default_sygy_element_engine>div>div').length ){
          //version mobile
          window.document.dispatchEvent(new CustomEvent('showModalEngine'));
        } else {
          if( $scroll ){
            $('body').removeClass('noscroll');
            $('.tgl-internbar-air.sta-show-responsive.fn-open').removeClass('fn-open');
            hotusa().scrollTo( $scroll, { 'height': spacer });
          };
        };
      })
    }

    

  })( document.querySelector('.tgl-menus-air'), document.querySelector('#default_sygy_element_engine'), document.querySelector('.tgl-cover-air.sta-hide-engine'), window.jQuery );

  // function check menu white
  (function (o, a, $) {
    if (o && a) {
      function check_white() {
        var space = 40,
          window_position = document.documentElement.scrollTop || document.body.scrollTop;
        if (window.innerWidth >= 1280) {
          if (window_position >= space) {
            o.classList.remove('sta-menu-white');
          } else {
            o.classList.add('sta-menu-white');
          }
        }
      };

      check_white();
      //scroll event
      window.addEventListener('scroll', function () {
        check_white();
      });
    } else if (document.querySelector('.tgl-menus-air') && document.querySelector('.tgl-menus-air').classList.contains('sta-menu-white')) {
      document.querySelector('.tgl-menus-air').classList.remove('sta-menu-white');
    }
  })(document.querySelector('.tgl-menus-air.sta-menu-white'), document.querySelector('.tgl-cover-air'), jQuery);

  // function check internbar white
  (function (o, a, $) {
    if (o && a) {
      function check_white() {
        var space = 40,
          window_position = document.documentElement.scrollTop || document.body.scrollTop;
        if (window.innerWidth >= 1280) {
          if (window_position >= space) {
            o.classList.remove('sta-internbar-white');
          } else {
            o.classList.add('sta-internbar-white');
          }
        }
      };

      check_white();
      //scroll event
      window.addEventListener('scroll', function () {
        check_white();
      });
    } else if (o && !a) {
      if (document.querySelector('.tgl-internbar-air').classList.contains('sta-internbar-white')) {
        document.querySelector('.tgl-internbar-air').classList.remove('sta-internbar-white');
      }
    }
  })(document.querySelector('.tgl-internbar-air.sta-internbar-white'), document.querySelector('.tgl-cover-air'), jQuery);

  // function check menu logo between links
  (function (o, $) {
    if (o) {
      var counter = o.querySelectorAll('.sta-main-links > .sta-menus-air_links-wrapper > .sta-menus-air_links-element').length,
      img2 = o.querySelector('.sta-menus-air_nav-logo .sta-menus-air_logo-img.sta-simple').src,
      img = $('.tgl-cover-air').length ? o.querySelector('.sta-menus-air_nav-logo .sta-menus-air_logo-img.sta-white').src : img2,
      selector_count = Math.round(counter / 2),
      intersection = document.querySelector(".sta-main-links > .sta-menus-air_links-wrapper > .sta-menus-air_links-element:nth-child(" + selector_count + ")"),
      logo_checker = true,
      url = $(o.querySelector('.sta-menus-air_nav-logo .sta-menus-air_logo-img.sta-white')).parent().attr('href'),
      $li = $("<li class='sta-menus-air_links-element fn-logo'><a href='"+url+"' class='sta-menus-air_links-element-wrapper' tabindex='0'></a></li>"),
      $figure = $("<figure class='sta-menus-air_links-element-logo'></figure>");
      function check_between() {
        if (window.innerWidth >= 1280 && logo_checker === true) {
          $('a',$li).append( $figure.css('background-image','url("'+img+'")') );
          $li.insertAfter(intersection);
          logo_checker = false;
        }
      }
      check_between();
      //scroll event
      window.addEventListener('scroll', function () {
        check_between();
        !window.scrollY
          ? $figure.css('background-image','url("'+img+'")')
          : $figure.css('background-image','url("'+img2+'")');
      });
      //resize event
      window.addEventListener('resize', function () {
        check_between();
      });
    }
  })(document.querySelector('.tgl-menus-air.sta-logo-between_links.sta-show-links.sta-logo-off.sta-book-aside'), jQuery);

  // function check menu links
  (function (o, $) {
    if (o) {
      var selector = o.querySelector('.sta-menus-air_nav-links.sta-main-links'),
        links_width = 0, logo_space = 0, btns_space = 0, call_space = 0, imgsCarga = false;
      function check_width() {
        if (window.innerWidth >= 1280) {

          if (document.querySelector('.sta-menus-air_nav-logo')) {
            logo_space = document.querySelector('.sta-menus-air_nav-logo').offsetWidth;
            document.querySelectorAll('.sta-menus-air_nav-logo img')[0].onload = check_width;
            document.querySelectorAll('.sta-menus-air_nav-logo img')[1].onload = check_width;
          } else { 
            logo_space = 0 
          }
          if (document.querySelector('.sta-menus-air_nav-morebtns')) { btns_space = document.querySelector('.sta-menus-air_nav-morebtns').offsetWidth } else { btns_space = 0 }
          if (document.querySelector('.sta-menus-air_nav-action')) { call_space = document.querySelector('.sta-menus-air_nav-action').offsetWidth } else { call_space = 0 }

          if (o.classList.contains('sta-show-links') && !selector.classList.contains('fn-open')) {
            links_width = selector.offsetWidth;
          }

          var elements_space = logo_space + btns_space + call_space,
            max_width = window.innerWidth - elements_space;

          if (links_width > max_width) {
            o.classList.remove('sta-show-links');
          } else {
            o.classList.add('sta-show-links');
            document.querySelector('body').classList.remove('noscroll');
          }
        }
      }
      check_width();
      //scroll event
      window.addEventListener('scroll', function () {
        check_width();
      });
      //resize event
      window.addEventListener('resize', function () {
        check_width();
      });
    }
  })(document.querySelector('.tgl-menus-air.sta-show-links'), jQuery);

  // function check menu btn book
  (function (o, a, $) {
    if (o && a) {
      function check_btn() {
        var space = $(a).offset().top + $(a).height() - 80;
        
        if(window.scrollY >= space){
          o.classList.add('fn-show-book')
        }else{
          o.classList.remove('fn-show-book');
        }

        setTimeout(() => {
          window.dispatchEvent(new Event('resize'));
        }, 400);
      };

      check_btn();
      //scroll event
      window.addEventListener('scroll', function () {
        check_btn();
      });
    }
  })(document.querySelector('.tgl-menus-air.sta-book-fixed'), document.querySelector('#default_sygy_element_engine'), jQuery);

  // function check menu logo
  (function (o, a, $) {
    if (o && a) {
      function check_logo() {
        var space = a.offsetHeight - 80,
          window_position = document.documentElement.scrollTop || document.body.scrollTop;
        if (window.innerWidth >= 1280) {
          if (window_position >= space) {
            o.classList.add('fn-show-logo');
          } else {
            o.classList.remove('fn-show-logo');
          }
        }
      };

      check_logo();
      //scroll event
      window.addEventListener('scroll', function () {
        check_logo();
      });
    }
  })(document.querySelector('.tgl-menus-air.sta-logo-off'), document.querySelector('.tgl-cover-air'), jQuery);

  // function toggle menus
  (function (a, $) {
    if (a.length) {
      var header = document.querySelector('.tgl-menus-air');
      for (var i = 0; i < a.length; i++) {
        var parent = a[i];
        parent.onclick = function () {
          // variables
          var menu_name = parent.dataset.toggle_menu,
            menu_selector = document.querySelector(menu_name);

          if (menu_selector.classList.contains('fn-open')) {
            document.querySelector('body').classList.remove('noscroll');
            menu_selector.classList.remove('fn-open');
            parent.classList.remove('fn-close');
            header.classList.remove('sta-openMenu');
            $('.js-toggle-submenu').children('.sta-menus-air_nav-links').removeClass('fn-open');
            setTimeout(function () {
              window.dispatchEvent(new Event('scroll'));
            }, 20);
          } else {
            if( !($(header).hasClass('sta-menuDesplegable') && $(header).hasClass('sta-show-links')) ){
            document.querySelector('body').classList.add('noscroll');
            }else{
              if(window.innerWidth <= 1280 ) document.querySelector('body').classList.add('noscroll');
            }
            menu_selector.classList.add('fn-open');
            parent.classList.add('fn-close');
            header.classList.add('sta-openMenu');
            var inp = document.querySelector(".sta-menus-air_nav-morebtns-element.sta-lang input");
            if( inp ) inp.checked = false;
            if (window.innerWidth >= 1280 && document.querySelector('.tgl-menus-air.sta-menu-white')) {
              document.querySelector('.tgl-menus-air.sta-menu-white').classList.remove('sta-menu-white');
            }
            if (window.innerWidth >= 1280 && document.querySelector('.sta-menus-air_photo-img.sta-main-placeholder')) {
              var placeholder = document.querySelector('.sta-menus-air_photo-img.sta-main-placeholder').dataset.placeholder;
              document.querySelector('.sta-menus-air_photo-img.sta-main-placeholder').style.backgroundImage = "url('" + placeholder + "')";
              document.querySelector('.sta-menus-air_photo-img.sta-main-placeholder img').src = placeholder;
            }
          }
        };
      }
    }
  })(document.querySelectorAll('.js-toggle-menu'), jQuery);

  // function toggle submenus
  (function (a, $) {
    if (a.length) {
      var header = document.querySelector('.tgl-menus-air');
      for (var i = 0; i < a.length; i++) {
        var parent = a[i].querySelector('.sta-menus-air_links-element-wrapper');
        parent.removeAttribute("href");
        parent.onclick = function () {

          // variables
          var menu_selector = $(this).siblings('.sta-menus-air_nav-links');
          if (menu_selector.hasClass('fn-open')) {
            document.querySelector('body').classList.remove('noscroll');
            menu_selector.removeClass('fn-open');
            parent.classList.remove('fn-close');
            setTimeout(function () {
              window.dispatchEvent(new Event('scroll'));
            }, 20);
          } else {
            $('.sta-menus-air_nav-links.sta-submenu.fn-open').removeClass('fn-open');
            if( !($(header).hasClass('sta-menuDesplegable') && $(header).hasClass('sta-show-links')) ){
            document.querySelector('body').classList.add('noscroll');
            }
            menu_selector.addClass('fn-open');
            document.querySelector(".sta-menus-air_nav-morebtns-element.sta-lang input").checked = false;
            if (window.innerWidth >= 1280 && document.querySelector('.tgl-menus-air.sta-menu-white')) {
              document.querySelector('.tgl-menus-air.sta-menu-white').classList.remove('sta-menu-white');
            }
            if (window.innerWidth >= 1280 && document.querySelector('.sta-menus-air_photo-img')) {
              var placeholder = document.querySelector('.sta-menus-air_photo-img').dataset.placeholder;
              document.querySelector('.sta-menus-air_photo-img').style.backgroundImage = "url('" + placeholder + "')";
              document.querySelector('.sta-menus-air_photo-img img').src = placeholder;
            }
          }
        };
      }
      $('.js-close-submenu').click(function () {
        $('.sta-menus-air_nav-links.sta-submenu').removeClass('fn-open');
        if ($(this).hasClass('sta-menus-air_nav-links-close')) {
          $('.sta-menus-air_nav-links.sta-main-links').removeClass('fn-open');
          $('.sta-menus-air_nav-btns-element.js-toggle-menu').removeClass('fn-close');
          document.querySelector('body').classList.remove('noscroll');
          setTimeout(function () {
            window.dispatchEvent(new Event('scroll'));
          }, 20);
        }
        if (window.innerWidth >= 1280 && document.querySelector('.tgl-menus-air.sta-show-links')) {
          document.querySelector('body').classList.remove('noscroll');
          setTimeout(function () {
            window.dispatchEvent(new Event('scroll'));
          }, 20);
        }
      });
    }
  })(document.querySelectorAll('.sta-menus-air_links-element.no_link'), jQuery);

  // function toggle subbars
  (function (o, $) {
    if (o) {
      if (window.innerWidth <= 1024) {
        document.querySelector('body').classList.add('bar-spacer');
      }

      var btn = o.querySelector('.sta-internbar-air_links-btn'),
      closer = o.querySelector('.sta-internbar-air_links-close');

      //$( o.querySelector('.sta-internbar-air_links') ).css('padding-left',$( o.querySelector('.sta-internbar-air_header .sta-internbar-air_header-title') ).innerWidth()+40);

      btn.onclick = function () {
        document.querySelector('body').classList.add('noscroll');
        o.classList.add('fn-open');
      }
      closer.onclick = function () {
        document.querySelector('body').classList.remove('noscroll');
        o.classList.remove('fn-open');
      }

      window.addEventListener('resize', function () {
        if (window.innerWidth <= 1024) {
          document.querySelector('body').classList.remove('noscroll');
          o.classList.remove('fn-open');
        }
      })
    }
  })(document.querySelector('.tgl-internbar-air.sta-show-responsive'), jQuery);

  // function placeholders menus
  (function (a, $) {
    if (a.length) {
      var placeholder = $(a).parent().siblings('.sta-placeholder').children('.sta-placeholder-img'),
      placeholderAda = $(a).parent().siblings('.sta-placeholder').children('.sta-placeholder-img img');
      for (var i = 0; i < a.length; i++) {
        var parent = a[i];

        parent.addEventListener("mouseenter", function () {
          var placeholder_img = this.dataset.placeholder_img;
          if (window.innerWidth >= 1280) {
            placeholder.attr("style", "background-image:url('" + placeholder_img + "')")
            placeholderAda.attr('src',placeholder_img);
          }
        });
        parent.addEventListener("mouseleave", function () {
          var placeholder_img = placeholder.attr('data-placeholder');
          if (window.innerWidth >= 1280) {
            placeholder.attr("style", "background-image:url('" + placeholder_img + "')")
            placeholderAda.attr('src',placeholder_img);
          }
        });

      }
    };
  })(document.querySelectorAll('.js-menu-placeholder'), jQuery);

  (function (a, $) {
    if (a.length) {
      load_imgs( a );
    };
  })(document.querySelectorAll('[data-lazyimg]'), jQuery);
  // function ladyload images onscroll
  window.addEventListener('scroll', function () {
    (function (a, $) {
      if (a.length) {
        var object = $(a);
        load_imgs(object);
      };
    })(document.querySelectorAll('[data-lazyimg]'), jQuery);
  });
  // function ladyload images onresize
  window.addEventListener('resize', function () {
    (function (a, $) {
      if (a.length) {
        var object = $(a);
        load_imgs(object);
      };
    })(document.querySelectorAll('[data-lazyimg]'), jQuery);
  });

  // function unique icons 
  (function (o, $) {
    if (o) {
      // variables 
      var $o = $(o),
        load_check = false;

      // load and check
      function load_font() {
        if (!load_check) {
          loadStyle("static/fonts/features/style.css");
          load_check = true;
        };
      }

      if (isScrolledIntoView($o[0], 300)) {
        load_font();
      };

      //scroll event
      window.addEventListener('scroll', function () {
        if (isScrolledIntoView($o[0], 300)) {
          load_font();
        };
      });
    }
  })(document.querySelector('._js-load-moreicons'), jQuery);

  // function modular sliders
  (function (a, $) {
    if (a.length) {

      //load sliders files
      var files_checker = true;
      function load_files() {
        if (files_checker) {
          loadScript("/templates/cadenas/air/js/libraries/slick.min.js", load_slider);
          loadStyle("/templates/cadenas/air/css/libraries/slick.min.css");
          files_checker = false;
        }
      }
      if (isScrolledIntoView(a[0], 300)) {
        load_files();
      }
      //scroll event
      window.addEventListener('scroll', function () {
        if (isScrolledIntoView(a[0], 300)) {
          load_files();
        }
      });

      // load modules slider
      function load_slider() {
        for (var i = 0; i < a.length; i++) {

          (function (parent) {
            // variables
            var slider_name = parent.dataset.slider_name,
            slider_showbtns = parent.dataset.slider_showbtns === 'true',
            slider_showdots = parent.dataset.slider_showdots === 'true',
            response_btn_dots = parent.dataset.response_btn_dots === "true",
            slider_autoplay_speed = parent.dataset.slider_autoplay_speed && parent.dataset.slider_autoplay_speed.trim() && !isNaN(parent.dataset.slider_autoplay_speed) ? parseInt(parent.dataset.slider_autoplay_speed) : 5000,
            slider_btns = parent.dataset.slider_btns,
            slider_fade = parent.dataset.slider_fade === 'true',
            slider_autoplay = parent.dataset.slider_autoplay === 'true',
            slider_infinite = parent.dataset.slider_infinite === 'false' ? false : true,
            slider_pc = parent.dataset.slides_pc,
            slider_tablet = parent.dataset.slides_tablet,
            slider_mobile = parent.dataset.slides_mobile,
            slider_rows = parent.dataset.slides_rows,
            slider_selector = parent.querySelector('.' + slider_name),
            arrayResponse = [
              {
                breakpoint: 1280,
                settings: {
                  slidesToShow: slider_pc,
                }
              },
              {
                breakpoint: 768,
                settings: {
                  slidesToShow: slider_tablet,
                }
              },
            ];

            if( !slider_selector ) return false;

            if( slider_selector.childElementCount < 2 ){
              slider_showdots = false;
              slider_showbtns = false;
              response_btn_dots = false;
            };

            if( response_btn_dots ){
              slider_showdots = true;
              slider_showbtns = false;
              arrayResponse.push({
                breakpoint: 1280,
                settings: {
                  dots: false,
                  arrows : true
                }
              });
            };

            hotusa().cargaScrollAuto({obj:parent,dual:true},function () {
              //init slider
              $(slider_selector).slick({
                dots: slider_showdots,
                arrows: slider_showbtns,
                prevArrow: "<div class='sta-btn-circle " + slider_btns + " slick-btn slick-prev' role='button' aria-label='left' tabindex='0'><i class='sta-btn-circle_icon icon-pointer-left'></i></div>",
                nextArrow: "<div class='sta-btn-circle " + slider_btns + " slick-btn slick-next' role='button' aria-label='right' tabindex='0'><i class='sta-btn-circle_icon icon-pointer-right'></i></div>",
                infinite: slider_infinite,
                useTransform: true,
                fade: slider_fade,
                cssEase: 'cubic-bezier(0.785, 0.135, 0.15, 0.86)',
                speed: 750,
                slidesToShow: slider_mobile,
                slidesToScroll: 1,
                rows: slider_rows,
                autoplay: slider_autoplay,
                autoplaySpeed: slider_autoplay_speed,
                swipeToSlide: true,
                mobileFirst: true,
                responsive: arrayResponse
              });
            });
            
          })( a[i] );

        };
      };
    };
  })(document.querySelectorAll('.js-active-slider'), jQuery);

  // function modular lightbox
  (function (a, $) {
    if (a.length) {
      //load sliders files
      var files_checker = true;
      function load_files() {
        if (files_checker) {
          loadScript("/templates/cadenas/air/js/libraries/lightbox.min.js", function () { return false });
          loadStyle("/templates/cadenas/air/css/libraries/lightbox.min.css");
          files_checker = false;
        }
      }
      if (isScrolledIntoView(a[0], 300)) {
        load_files();
      }
      //scroll event
      window.addEventListener('scroll', function () {
        if (isScrolledIntoView(a[0], 300)) {
          load_files();
        }
      });

      for (var i = 0; i < a.length; i++) {
        a[i].onclick = function () {
          setTimeout(function () {
            var resizeEvent = window.document.createEvent('UIEvents');
            resizeEvent.initUIEvent('resize', true, false, window, 0);
            window.dispatchEvent(resizeEvent);
          }, 10);
        };
      }
    };
  })(document.querySelectorAll('a[data-lightbox]'), jQuery);

  // function modular features dropdown
  (function (a, $) {
    if (a.length) {

      var ocultBtn = function ( $ext, $inter ) {
        return $inter.height() <= $ext.height();
      };

      for (var i = 0; i < a.length; i++) {
        (function(o){
          var n = o.querySelector('.sta-features-air_list').childElementCount,
          $o = $(o);

          $o.addClass('less3_'+ n%3 );
          
          if( !$o.hasClass('sta-features-highlights') ) $o.addClass('less4_'+ n%4);

          if($o.hasClass('sta-open')){
            return true;
          }
          
          if(  ocultBtn($( o.querySelector('.sta-features-air_listMax')), $(o.querySelector('.sta-features-air_list')) )  ){
            o.classList.add('sta-notBtn');
          } else {
            $( o.querySelector('.sta-features-air_btns-element') ).click(function () {
              setTimeout(function () {
                $("body,html").animate({
                  scrollTop: o.offset().top
                }, 0);
              }, 10);
            });
          };

        })( a[i] );
      };

    };
  })(document.querySelectorAll('.tgl-features-air'), jQuery);

  // load unique map
  (function ( o,$,seo ) {
    if ( !o || !$ ) return false;

    //load map
    function initmap() {
      // variables
      var map = o,
      map_lat = lat,
      map_lng = long,
      map_lat_marker2 = lat_marker2,
      map_lng_marker2 = long_marker2,
      map_lat_marker3 = lat_marker3,
      map_lng_marker3 = long_marker3,
      map_lat_marker4 = lat_marker4,
      map_lng_marker4 =  long_marker4,
      map_zoom = parseInt(map.dataset.map_zoom),
      map_marker = marker,  
      map_marker2 = marker2, 
      map_marker3 = marker3, 
      map_marker4 = marker4, 
      art_map;
    
      //default value
      if( !map_zoom ) map_zoom = 17;

      function start_contact_map() {
        art_map = new GMaps({
          div: '#map-object',
          lat: map_lat,
          lng: map_lng,
          zoom: map_zoom,
          mapTypeControl: false,
          scaleControl: false,
          fullscreenControl: false,
          clickableIcons: false,
          streetViewControl: false,
          mapId: idStyleMap,
          scrollwheel : mapaScroll,
          zoomControl : 'ontouchstart' in document.documentElement ? false : true, //if mobile not buttons
        });
        art_map.drawOverlay({
          lat: map_lat,
          lng: map_lng,
          content: "<div class='map-marker' style='background-image:url(" + map_marker + ")'></div>"
        });

        art_map.drawOverlay({

          lat: map_lat_marker2,
          lng: map_lng_marker2,
          content:"<div class='map-marker2' style='background-image:url(" + map_marker2+ ")'></div>"

        })


        art_map.drawOverlay({

          lat: map_lat_marker3,
          lng: map_lng_marker3,
          content:"<div class='map-marker3' style='background-image:url(" + map_marker3 + ")'></div>"

        })
        art_map.drawOverlay({

          lat: map_lat_marker4,
          lng: map_lng_marker4,
          content:"<div class='map-marker4' style='background-image:url(" + map_marker4 + ")'></div>"

        })
      };

      if ($(map).is(':visible')) {
        start_contact_map();
        $(o).addClass('mapLoad')
      };
    };

    var map_key = o.dataset.map_key,
    files_checker = true;
    function load_files() {
      if (files_checker) {
        files_checker = false;
        var script1 = document.createElement('script');
        script1.onload = function () {
          var script2 = document.createElement('script');
          script2.onload = function () {
            initmap();
          };
          script2.src = "https://maps.google.com/maps/api/js?key=AIzaSyBm73To9KCmz6BJCUnS0sztyeuF0r5fPrU";
          document.head.appendChild(script2);
        };
        script1.src = "/templates/cadenas/air/js/libraries/gmaps.min.js";
        document.head.appendChild(script1);
      };
    };
    
    function loadImgMap(){
      var $img = $(o.querySelector('#map-object') ),
      img = new Image(),
      fnClick = function () {
        $img.off('click',fnClick);
        load_files();
        $img.css('background-image','');
      };

      if( staticImg ){
        img.src = staticImg;
        img.onload = function () {
          $img.css('background-image', "url('" + this.src + "')").addClass('notMarker');
        };
        if( !$(o).hasClass('sta-notMap') ){
          $img.on('click',fnClick);
        }
      } else {
        img.src = "https://maps.googleapis.com/maps/api/staticmap?" +
        "size=640x640&" +
        "scale=2&" +
        "language=" + $('html').attr('lang') + "&" +
        "map_id=" + idStyleMapStatic + "&" +
        "key=AIzaSyBm73To9KCmz6BJCUnS0sztyeuF0r5fPrU&" +
        "center=" + lat + "," + long + "&" +
        "zoom="+zoomStatic;
        
        img.onload = function () {
          $img.css('background-image', "url('" + marker + "'), url('" + this.src + "')");
        };
        $img.on('click',fnClick);
      }


    };
    
    var lat_marker2 = o.dataset.map_lat_marker2,
    long_marker2 = o.dataset.map_lng_marker2,
    lat_marker3= o.dataset.map_lat_marker3,
    long_marker3 = o.dataset.map_lng_marker3,
    lat_marker4 = o.dataset.map_lat_marker4,
    long_marker4 = o.dataset.map_lng_marker4,
    lat = o.dataset.map_lat,
    long = o.dataset.map_lng,
    marker = o.dataset.map_marker,
    marker2 = o.dataset.map_marker2,
    marker3 = o.dataset.map_marker3,
    marker4 = o.dataset.map_marker4,
    staticImg = o.dataset.map_img_static,
    zoomStatic = o.dataset.map_zoom_static,
    idStyleMapStatic = o.dataset.map_id_style_static ? o.dataset.map_id_style_static : 'a053269f0ab2d031',
    idStyleMap = o.dataset.map_id_style_map ? o.dataset.map_id_style_map : '4e83657b6cd228b4',
    mapaScroll = o.dataset.map_zoom_scroll ? false : true,
    loadImg = false;

    zoomStatic = zoomStatic && !isNaN(zoomStatic) ? parseInt(zoomStatic) : 16;
    
    //equal city and country and province
    (function(address){
      var city = address.querySelector('.sta-city').textContent.trim(),
      province = address.querySelector('.sta-province').textContent.trim(),
      country = address.querySelector('.sta-country').textContent.trim();

      if( city == province || province == country || !province ) address.querySelector('.sta-province').remove();
      if( city == country || !country ) address.querySelector('.sta-country').remove();
    })( o.querySelector('.sta-address') );
    
    if (isScrolledIntoView(o, 300) && !loadImg) {
      loadImg = true;
      loadImgMap();
    };

    //scroll event
    window.addEventListener('scroll', function () {
      if (isScrolledIntoView(o, 300) && !loadImg) {
        loadImg = true;
        loadImgMap();
      }
    });

    if( seo && seo.hotel ){
      if( o.querySelector(".sta-map-air_info-element .sta-tel1") && seo.hotel.tel ){
        o.querySelector(".sta-map-air_info-element .sta-tel1").href = "tel:"+seo.hotel.tel;
        o.querySelector(".sta-map-air_info-element .sta-tel1").innerHTML = '<h2>'+(seo.hotel.textTel ? seo.hotel.textTel : seo.hotel.tel)+'</h2>';
      } else {
        o.querySelector(".sta-map-air_info-element .sta-tel1").remove();
      };

      if( o.querySelector(".sta-map-air_info-element .sta-tel2") && seo.hotel.tel2 ){
        o.querySelector(".sta-map-air_info-element .sta-tel2").href = "tel:"+seo.hotel.tel2;
        o.querySelector(".sta-map-air_info-element .sta-tel2").innerHTML = '<h2>'+(seo.hotel.text2Tel ? seo.hotel.text2Tel : seo.hotel.tel2)+'</h2>';
      } else {
        o.querySelector(".sta-map-air_info-element .sta-tel2").remove();
      };

      if( o.querySelector(".sta-map-air_info-element .sta-fax") && seo.hotel.fax ){
        o.querySelector(".sta-map-air_info-element .sta-fax").href = "tel:"+seo.hotel.fax;
        o.querySelector(".sta-map-air_info-element .sta-fax").innerHTML = '<h2>'+seo.hotel.fax+'</h2>';
      } else {
        o.querySelector(".sta-map-air_info-element .sta-fax").remove();
      };

      // control tamaño de mail en mapa
      var mail = o.querySelector(".sta-map-air_info-element .sta-mail");
      if( mail && seo.hotel.mail ){
        var $mail = $(mail);
        mail.href = 'mailto:'+seo.hotel.mail+'?subject='+encodeURI(seo.hotel.name);

        mail.innerHTML = '<h2>a</h2>';
        var hStart =  $mail.height();

        mail.innerHTML = '<h2>'+seo.hotel.mail+'</h2>';

        var letra = parseInt( $mail.css('font-size') );

        var hEnd = $mail.height();
        $mail.css('transition','none');
        while( hEnd > hStart ){
          letra--;
          $mail.css('font-size', letra+'px');
          hEnd = $mail.height();
        }
        $mail.css('transition','');

      } else {
        mail.remove();
      };
    };

    if( !o.querySelector('.sta-map-air_info-element.socials a') ) o.querySelector('.sta-map-air_info-element.socials').remove();

  })(document.querySelector('.tgl-map-air'), window.jQuery, window.dataSeo );

  // function modular scroll events
  (function (a, $) {
    if (a.length) {
      for (var i = 0; i < a.length; i++) {
        var parent = a[i];

        parent.addEventListener("click", function () {
          var current_element = this,
          point = current_element.dataset.scroll_to,
          spacer = current_element.dataset.scroll_spacer;
          $('body').removeClass('noscroll');
          $('.tgl-internbar-air.sta-show-responsive.fn-open').removeClass('fn-open');
          hotusa().scrollTo($(point), { 'height': spacer });
        });
      }

    };
  })(document.querySelectorAll('.js-scrollto'), jQuery);

  // function unique fixed gallery
  (function (a, $) {
    if ( !a.length ) return false;

    var calc_gallery = function(o,_o){
      // var window_position = (document.documentElement.scrollTop || document.body.scrollTop) + window.innerHeight,
      // content_height = document.querySelector('.tgl-cardpage-air'),
      // gallery_positionTop = content_height.offsetTop,
      // gallery_position = content_height.offsetTop + content_height.offsetHeight,
      // gallery_contentTop = content_height.offsetTop;

      var _s = _o.offset().top;

      if( _s >= hotusa().getScrollTop() ){
        //top
        o.classList.add('fn-stopStart');
        o.classList.remove('fn-stop');

      } else if( _s + _o.innerHeight() <= hotusa().getScrollTop() + hotusa().getWindowHeight() ) {
        //bottom
        o.classList.add('fn-stop');
        o.classList.remove('fn-stopStart');
      } else {
        //center
        o.classList.remove('fn-stop','fn-stopStart');
      };
    },
    ev = function(o){
      var $fatherModule = $(o).parent();

      calc_gallery(o,$fatherModule);

      $(window).scroll(function () {
        calc_gallery(o,$fatherModule);
      });
    };

    for (var i = 0; i < a.length; i++) ev( a[i] );

  })(document.querySelectorAll('.sta-cardpage-air_multimedia'), jQuery);

  setTimeout(function () {
    $('.tgl-menus-air').css('opacity', '1');
    $('.tgl-internbar-air').css('opacity', '1');
  }, 1000);
  // Document ready END
});

$(window).load(function () {

  // function first motor click
  (function (o, $) {
    if (o) {
      var checker = true;
      o.addEventListener('click', function () {
        if (checker) {
          var spacer = (window.innerHeight - 80) / 2;
          hotusa().scrollTo(o, { 'height': spacer });
          checker = false;
        } else {
          return false;
        }
      });
    };
  })(document.querySelector('.sta-cover-air_engine'), jQuery);

  // function modular info popup
  (function (a, $) {
    if (a.length) {
      for (var i = 0; i < a.length; i++) {
        (function(mod){
          mod.style.display = 'block'; 
          $( mod.previousElementSibling ).click(function () {
            $(mod.querySelector('.sta-infopop-air_services')).resize();
            setTimeout(function(){
              mod.classList.add('fn-open');
            },250);
          });
  
          var $next = $(mod.previousElementSibling);

          if( $next.hasClass('sta-popoffer-air_gadget hotels') ){
            var avisos = document.querySelectorAll('.tgl-avisos-air');
            
            $next.click(function () {
              var $obj = $(mod);
              $obj.addClass('fn-open');
              $( mod.querySelectorAll('.sta-infopop-air_backmask, .sta-infopop-air_close') ).click(function () {
                $obj.removeClass('fn-open');
              });
            });

            var $devices = $( document.querySelector('.tgl-devicesheader-air') ),
            avisosElem = document.querySelectorAll('.tgl-globalAlertas-air .tgl-avisos-air'),
            $headerP = $(document.querySelector('.tgl-menus-air')),
            $header = $($headerP[0].querySelector('.sta-menus-air_nav')),
            $interbar = $(document.querySelector('.tgl-internbar-air')),
            $imgLogo = $(document.querySelector('.tgl-cover-air .sta-cover-air_logo')),
            $imgLogoWhite = $(document.querySelector('.sta-menus-air_logo-img.sta-white')),
            $noLogo = $(document.querySelector('.tgl-cover-air.sta-devices-hide>div:not(.sta-cover-air_engine)'));

            $(window).ready(function(){
              var height = (function(){
                var _height = 0;
                for( var i = 0; i < avisosElem.length; i++ ){
                  (function( av ){
                    if( $(av).css('display') !== 'none' ){
                      var heigIndi = $(av).outerHeight();
                      _height += heigIndi;
                      av.querySelector('.sta-avisos-air_closeBtn').addEventListener('change',function(){
                        if( !this.checked ) return false;
                        alturaAll -= heigIndi;
                        avisos -= heigIndi;
                      }, false);
                    };
                  })( avisosElem[i] );
                }
                return _height;
              })(),
              avisos = height,
              alturaAll = avisos,
              altura2 = 0;
              if( window.innerWidth < 1024 ){
                //title superior mobile
                if( $devices.length ) alturaAll += $devices.outerHeight();

                $(window).scroll(function(){
                  $(window).scrollTop() < alturaAll
                  ? $next.addClass('sta-absolute').css('top',alturaAll +'px')
                  : $next.removeClass('sta-absolute').css('top',0);
                });
              } else {
                //header
                if( $header.length ) alturaAll += $header.outerHeight();
                //listado habitaciones
                if( $interbar.length ) alturaAll += $interbar.outerHeight();
                altura2 = alturaAll - avisos;
                $(window).scroll(function(){
                  $(window).scrollTop() < avisos
                  ? $next.css('top',alturaAll+'px')
                  : $next.css('top',altura2 +'px');
                  if( avisos != 0 ){
                    $(window).scrollTop() < avisos
                    ? $next.addClass('sta-absolute')
                    : $next.removeClass('sta-absolute');
                  }
                });
              }
            });

          }
        })(a[i]);
      }

      $( document.querySelectorAll('.js-close-infopopup') ).click(function () {
        $('.tgl-infopop-air').removeClass('fn-open');
      });
    };
  })(document.querySelectorAll('.tgl-infopop-air'), jQuery);

  // function modular info dropdowns
  (function (a, $) {
    if (a.length) {
      for (var i = 0; i < a.length; i++) {
        var module = a[i];

        var opener = module.querySelector('.sta-cardpage-air_dropdowns-header');
        opener.addEventListener("click", function () {
          var btn = this;
          var dropdown = btn.parentNode;

          if (dropdown.classList.contains('fn-open')) {
            dropdown.classList.remove('fn-open');
          } else {
            $('.sta-cardpage-air_dropdowns-element').removeClass('fn-open');
            dropdown.classList.add('fn-open');
          }
        });
      }
    };
  })(document.querySelectorAll('.sta-cardpage-air_dropdowns-element'), jQuery);

  // function unique cookies popup
  (function (o, $) {
    if (o) {
      o.style.display = 'block';
      setTimeout(function () {
        o.classList.add('fn-open');
      }, 50);

      var closer = document.querySelector('.js-accept-cookies');
      closer.onclick = function () {
        o.classList.remove('fn-open');
      }
    };
  })(document.querySelector('._tgl-cookies-air'), jQuery);

  window.scrollTo(0, 1);
  window.scrollTo(0, 0);
  $('.tgl-menus-air').css('opacity', '1');
  $('.tgl-internbar-air').css('opacity', '1');
  // Window load END
});


//carga de opiniones
(function( lista, footer, id, $, h ){
  if( !lista || !footer || !id || !$ || !h ) return false;

  var combinarDatos = function( _json ){
    var _jsonTemp = _json,
    keys = _.keys(_json);
    
    //combinamos
    for (var i = 0; i < keys.length; i++) {

      if( jsonGeneral[ keys[i] ].totalOpiniones > 0 && _jsonTemp[ keys[i] ].opiniones && _jsonTemp[ keys[i] ].opiniones.length ){
        jsonGeneral[ keys[i] ].opiniones = jsonGeneral[ keys[i] ].opiniones.concat( _jsonTemp[ keys[i] ].opiniones );
        jsonGeneral.all.opiniones = jsonGeneral.all.opiniones.concat( _jsonTemp[ keys[i] ].opiniones );
      };
      jsonGeneral[ keys[i] ].loadNextPage = _jsonTemp[ keys[i] ].loadNextPage;
      if( jsonGeneral[ keys[i] ].loadNextPage ) jsonGeneral.all.loadNextPage = true;

    };
    
    $paginacionMod.removeClass('sta-loading');

    cargarOpiniones();
  },
  cargamosMore = function(){
    if( cargados < jsonGeneral[idioma_select].opiniones.length ){
      //faltan por cargar
      cargarOpiniones();
    } else if( cargados >= jsonGeneral[idioma_select].opiniones.length && jsonGeneral[idioma_select].loadNextPage ){
      paginacionRuta++;
      $paginacionMod.addClass('sta-loading').addClass('sta-hide');
      paginacionActive = false;
      
      h.cargarJSON(ruta(),combinarDatos);
    };
  },
  dobleCero = function(num){
    var tam = num.toString().length;
    if( tam < 2 ) num = '0'+num;
    return num;
  },
  crearHtml = function( obj ){
    var $html = $backup.clone();

    $( $html[0].querySelector(".tgl-reviews-air_list-element-header .tgl-reviews-air_element-header-name") ).text( obj.persona );
    if( obj.lugar ) $( $html[0].querySelector(".tgl-reviews-air_list-element-header .tgl-reviews-air_element-header-name") ).append( "<small>|</small>" + obj.lugar );

    var fecha = new Date( obj.fecha );
    $( $html[0].querySelector(".tgl-reviews-air_list-element-header .tgl-reviews-air_element-header-date") ).text( dobleCero( fecha.getDate() ) + '/' + dobleCero( fecha.getMonth()+1 ) + '/' + fecha.getFullYear() );

    var $tool = $($html[0].querySelector(".tgl-reviews-air_list-element-specs")),
    lis = _.keys( obj.nota_servi );
    for (var i = 0; i < lis.length; i++){
      (function(li){
        if( obj.nota_servi[li] !== null ){
          $( $html[0].querySelector(".tgl-reviews-air_list-element-specs") )
          .append( $("<div></div>",{class:'tgl-reviews-air_element-specs-point'})
            .append( $("<p></p>",{class:'tgl-reviews-air_specs-point-text'}).text( li ) )
            .append( $("<span></span>",{class:"tgl-reviews-air_specs-point-number"}).text( obj.nota_servi[li]+"/10" ) )
          );
        };
      })(lis[i]);
    };
    
    $( $html[0].querySelector(".tgl-reviews-air_element-foot-comment .tgl-reviews-air_foot-comment-title") ).text( obj.text );
    $( $html[0].querySelector(".tgl-reviews-air_element-foot-comment .tgl-reviews-air_foot-comment-text") ).text( obj.titulo );

    $( $html[0].querySelector(".tgl-reviews-air_element-foot-grade .tgl-reviews-air_grade-box-number") ).text( Math.round(obj.nota*10)/10 );
    if( !obj.recomendado ) $($html[0].querySelector(".tgl-reviews-air_element-foot-grade .tgl-reviews-air_foot-grade-phrase")).remove();

    return $html;
  },
  cargarOpiniones = function(){
    for (var i = 0; i < max && cargados < jsonGeneral[idioma_select].opiniones.length; i++, cargados++) {
      $lista.append( crearHtml( jsonGeneral[idioma_select].opiniones[cargados] ) );
    };

    if( (cargados < jsonGeneral[idioma_select].opiniones.length || jsonGeneral[idioma_select].loadNextPage ) && !paginacionActive ){
      $paginacionMod.removeClass('sta-hide');
      paginacionActive = true;
    } else if( $paginacionMod.length && cargados >= jsonGeneral[idioma_select].opiniones.length && paginacionActive ){
      if( !jsonGeneral[idioma_select].loadNextPage ){
        $paginacionMod.addClass('sta-hide');
        paginacionActive = false;
      }
    };
  },
  controlIdioma = function(){
    //Si el idioma seleccionado no existe seleccionamos el por defecto EN
    if( !jsonGeneral[idioma_select] ){
      idioma_select = idiomaDefault;
      //comprobamos el de por defecto, y si no hay cogemos el primero que haya
      if( !jsonGeneral[idioma_select] ) idioma_select = _.keys(jsonGeneral)[0];
    };
  },
  $lista = $(lista),
  $paginacionMod = $(footer),
  $backup = $( lista.querySelector('.tgl-reviews-air_list-element') ).clone().removeClass('sta-oculto'),
  idioma_act = $('html').attr('lang').toUpperCase(),
  idioma_select = idioma_act,
  idiomaDefault = 'all',
  paginacionRuta = 1,
  paginacionActive = true,
  max = 10,
  cargados = 0,
  jsonGeneral = false,
  ruta = function(){
    return '/api/cms/opiniones/get/'+id+'/'+paginacionRuta+'/'+idioma_act
  },
  callback = function(_json){
    jsonGeneral = _json;
    
    var keys = _.keys(jsonGeneral);

    jsonGeneral.all = { opiniones : [], loadNextPage : false, totalOpiniones : 0 };

    if( !keys.length ){
      console.trace('Sin opiniones');
    } else {

      //creamos all
      for (var i = 0; i < keys.length; i++) {
        if( jsonGeneral[ keys[i] ].totalOpiniones > 0 && jsonGeneral[ keys[i] ].opiniones && jsonGeneral[ keys[i] ].opiniones.length ){
          jsonGeneral.all.opiniones = jsonGeneral.all.opiniones.concat( jsonGeneral[ keys[i] ].opiniones );
          jsonGeneral.all.totalOpiniones += jsonGeneral[ keys[i] ].totalOpiniones;
          if( jsonGeneral[ keys[i] ].loadNextPage ) jsonGeneral.all.loadNextPage = true;
        };
      };

      //seleccionamos el idioma seleccionado (si hay), el idioma por defecto o el primero que obtenga.
      controlIdioma();

      $paginacionMod.removeClass('sta-loading');
      
      cargarOpiniones();

      $( footer.querySelector('.tgl-reviews-air_foot-btn') ).click( cargamosMore );
    };

  };

  $lista.empty();

  $('main').addClass('sta-init-space');

  h.cargarJSON(ruta(),callback);

})( document.querySelector('.tgl-reviews-air_list'), document.querySelector('.tgl-reviews-air_foot'), dataSeo && dataSeo.hotel && dataSeo.hotel.id, window.jQuery, window.hotusa && hotusa() );

//validation and envio form newsletters
(function(o,seo,$,h){
  if( !o || !$ || !h || !seo || !seo.hotel || !seo.hotel.name ) return false;
  var form = o.querySelector('form'),
  $form = $( o.querySelector('form') ),
  obj = {
    fidelTour : $form.data('fideltour_code').trim(),
    url : $form.data('urldirect').trim(),
    recaptcha : $form.data('recaptcha').trim(),
    mail : {
      $p : $('.fn-email',$form),
      $inp : $('.fn-email input',$form)
    },
    poli : {
      $p : $('.fn-poli',$form),
      $check : $('.fn-poli input',$form)
    },
    error : {
      $o : $('.sta-error',$form),
      copy : {
        $empty : $('<li id="g_form_error_empty"></li>').text( form.copyEmpty.value ),
        $email : $('<li id="g_form_error_email"></li>').text( form.copyEmail.value ),
        $policy : $('<li id="g_form_error_politicas"></li>').text( form.copyPoliticas.value ),
        $ok : $('<li></li>').text( form.copyOk.value )
      }
    }
  },
  valid = function(){
    var enviar = true;

    obj.error.$o.empty().removeClass('sta-newsletter-air_warning-text sta-newsletter-air_done-text');

    if( h.mail( obj.mail.$inp.val().trim() ) ){
      obj.mail.$p.removeClass('invalid')
    } else {
      enviar = false;
      obj.mail.$p.addClass('invalid');
      obj.error.$o.append( obj.error.copy.$email );
    };
    
    if( obj.poli.$check.prop('checked') ){
      obj.poli.$p.removeClass('invalid')
    } else {
      enviar = false;
      obj.poli.$p.addClass('invalid');
      obj.error.$o.append( obj.error.copy.$policy );
    };

    if( !enviar ) obj.error.$o.addClass('sta-newsletter-air_warning-text');

    return enviar;
  },
  ajax = function( datos ){
    $.ajax({
      type: 'POST',
      url: obj.url ? obj.url : window.location.pathname.replace('.html', '/form.html'),
      async: false,
      data: JSON.stringify( datos ),
      success: function (n) {
        processEnvio = false;
        switch (n) {
          case 'OK':
            form.reset();
            obj.error.$o.append( obj.error.copy.$ok ).addClass('sta-newsletter-air_done-text');
            break;
          case 'ERR':
            console.trace("Not template",n);
            break;
          case 'KO - Error Formato Datos JSON':
          case 'KO':
          default:
            console.trace(n);
            break;
        };
      },
      error: function (n) {
        processEnvio = false;
        console.trace("ERROR:", n);
      }
    });
  },
  ajaxFidelTour = function( datos ){
    $.ajax({
      type: 'POST',
      url: 'https://backend.fideltour.com/api/contacts/subscription/?hc=' + obj.fidelTour + '&i=1&lang=' + $('html').attr('lang') + '&tags=NL',
      async: false,
      data: "email=" + encodeURIComponent(datos.d.email),
      success: function (n) {
        processEnvio = false;

        if( n.indexOf('correctamente') >= 0 ){
          form.reset();
          obj.error.$o.append( obj.error.copy.$ok ).addClass('sta-newsletter-air_done-text');
        } else {
          console.trace("Error: fideltour",n);
        }
      },
      error: function (n) {
        processEnvio = false;
        console.trace("ERROR:", n);
      }
    })
  },
  enviar = function(){
    var datos = {
      d : {
        nombreHotel : seo.hotel.name,
        email       : obj.mail.$inp.val().trim(),
        url         : location.origin + location.pathname
      }
    };

    if( obj.recaptcha ){
      grecaptcha.ready(function() {
        grecaptcha.execute(obj.recaptcha,{action: 'sendForm'}).then(function(token) {
          obj.fidelTour
          ? ajaxFidelTour(datos)
          : ajax(datos);
        });
      });
    } else {
      obj.fidelTour
      ? ajaxFidelTour(datos)
      : ajax(datos);
    };
  };

  $form.submit(function(e){
    e.preventDefault();
    if( valid() ) enviar();
  });

  if( obj.recaptcha ) h.cargarFicheroJS('https://www.google.com/recaptcha/api.js?render='+obj.recaptcha);

})( document.querySelector('.tgl-newsletter-air'), window.dataSeo, window.jQuery, window.hotusa && hotusa() );

//formulario de contacto
(function( form, $, h ){
  if( !form || !$ || !h ) return false;

  var valid = function(){
    var enviar = true,
    empty = false;

    obj.error.$o.empty().removeClass('sta-cardpage-air_warning-text sta-cardpage-air_done-text');

    for (var i = 0; i < obj.obligText.length; i++) {
      (function( elem ){
        if( elem.o.value.trim() ){
          elem.$p.removeClass('invalid');
        } else {
          elem.$p.addClass('invalid');
          enviar = false;
          empty = true;
        }
      })( obj.obligText[i] );
    };

    if( empty ) obj.error.$o.append( obj.error.copy.$empty );
    
    if( !h.mail( obj.email.o.value.trim() ) ){
      enviar = false;
      obj.email.$p.addClass('invalid');
      obj.error.$o.append( obj.error.copy.$email );
    };
    
    if( obj.policy.o.checked ){
      obj.policy.$p.removeClass('invalid');
    } else {
      enviar = false;
      obj.policy.$p.addClass('invalid');
      obj.error.$o.append( obj.error.copy.$policy );
    };

    if( !enviar ){
      obj.error.$o.addClass('sta-cardpage-air_warning-text');
      processEnvio = false;
    };

    return enviar;
  },
  ajax = function( datos ){
    $.ajax({
      type: 'POST',
      url: window.location.pathname.replace('.html', '/form.html'),
      async: false,
      data: JSON.stringify( datos ),
      success: function (n) {
        processEnvio = false;
        switch (n) {
          case 'OK':
            form.reset();
            obj.error.$o.append( obj.error.copy.$ok ).addClass('sta-cardpage-air_done-text');
            break;
          case 'ERR':
            console.trace("Not template",n);
            break;
          case 'KO - Error Formato Datos JSON':
          case 'KO':
          default:
            console.trace(n);
            break;
        };
      },
      error: function (n) {
        processEnvio = false;
        console.trace("ERROR:", n);
      }
    });
  },
  enviar = function(){
    var datos = {
      d : {
        name    : obj.name.o.value.trim(),
        surname : obj.surname.o.value.trim(),
        email   : obj.email.o.value.trim(),
        telephone : obj.telephone.o.value.trim(),
        comments : obj.comments.o.value.trim(),
        policy  : obj.acept_mail.o.checked ? 'yes' : 'no'
      }
    };

    if( obj.recaptcha ){
      grecaptcha.ready(function() {
        grecaptcha.execute(obj.recaptcha,{action: 'sendForm'}).then(function(token) {
          ajax(datos);
        });
      });
    } else {
      ajax(datos);
    };
  },
  obj = {
    url : $(form).data('url').trim(),
    idProd : $(form).data('id'),
    recaptcha : $(form).data('recaptcha').trim(),
    name : {
      o   : form.name,
      $p  : $(form.name).parent()
    },
    surname : {
      o   : form.surname,
      $p  : $(form.surname).parent()
    },
    email : {
      o   : form.email,
      $p  : $(form.email).parent()
    },
    telephone : {
      o   : form.telephone,
      $p  : $(form.telephone).parent()
    },
    comments : {
      o   : form.comments,
      $p  : $(form.comments).parent()
    },
    policy : {
      o   : form.policy,
      $p  : $(form.policy).parent()
    },
    acept_mail : {
      o   : form.acept_mail,
      $p  : $(form.acept_mail).parent()
    },
    obligText : [],
    error : {
      $o : $( form.querySelector('.sta-error') ),
      copy : {
        $empty : $('<li id="g_form_error_empty"></li>').text( form.copyEmpty.value ),
        $email : $('<li id="g_form_error_email"></li>').text( form.copyEmail.value ),
        $policy : $('<li id="g_form_error_politicas"></li>').text( form.copyPoliticas.value ),
        $ok : $('<li></li>').text( form.copyOk.value )
      }
    }
  },
  processEnvio = false;

  obj.obligText.push( obj.name, obj.surname, obj.telephone, obj.email, obj.comments );

  $( form ).submit(function(e){
    e.preventDefault();
    
    if( !processEnvio ){
      processEnvio = true;
      if( valid() ) enviar();
    }
    
  });

  if( obj.recaptcha ) h.cargarFicheroJS('https://www.google.com/recaptcha/api.js?render='+obj.recaptcha);

})( document.querySelector('.formContact'), window.jQuery, window.hotusa && hotusa() );

//formulario de contacto Ampliado
(function( form, $, h ){
  if( !form || !$ || !h ) return false;

  var valid = function(){
    var enviar = true,
    empty = false;
    
    obj.error.$o.empty().removeClass('sta-cardpage-air_warning-text sta-cardpage-air_done-text');

    for (var i = 0; i < obj.obligText.length; i++) {
      (function( elem ){
        if( elem.o.value.trim() ){
          elem.$p.removeClass('invalid');
        } else {
          elem.$p.addClass('invalid');
          enviar = false;
          empty = true;
        }
      })( obj.obligText[i] );
    };

    if( empty ) obj.error.$o.append( obj.error.copy.$empty );
    
    if( !h.mail( obj.email.o.value.trim() ) ){
      enviar = false;
      obj.email.$p.addClass('invalid');
      obj.error.$o.append( obj.error.copy.$email );
    };
    
    if( obj.policy.o.checked ){
      obj.policy.$p.removeClass('invalid');
    } else {
      enviar = false;
      obj.policy.$p.addClass('invalid');
      obj.error.$o.append( obj.error.copy.$policy );
    };

    if( !enviar ){
      obj.error.$o.addClass('sta-cardpage-air_warning-text');
      processEnvio = false;
    };

    return enviar;
  },
  ajax = function( datos ){
    $.ajax({
      type: 'POST',
      url: window.location.pathname.replace('.html', '/form.html'),
      async: false,
      data: JSON.stringify( datos ),
      success: function (n) {
        processEnvio = false;
        switch (n) {
          case 'OK':
            typeof dataLayer !== 'undefined' 
              ? dataLayer.push({'event': 'reschase'}) 
              : null;
            form.reset();
            obj.error.$o.append( obj.error.copy.$ok ).addClass('sta-cardpage-air_done-text');
            break;
          case 'ERR':
            console.trace("Not template",n);
            break;
          case 'KO - Error Formato Datos JSON':
          case 'KO':
          default:
            console.trace(n);
            break;
        };
      },
      error: function (n) {
        processEnvio = false;
        console.trace("ERROR:", n);
      }
    });
  },
  enviar = function(){
    var formatDate = obj.date.o.value.trim().split('-'),
    datos = {
      d : {
        name    : obj.name.o.value.trim(),
        surname : obj.surname.o.value.trim(),
        telephone : obj.telephone.o.value.trim(),
        email   : obj.email.o.value.trim(),
        hour : obj.hour.o.value.trim(),
        date : formatDate[2]+'/'+formatDate[1]+'/'+formatDate[0],
        numberpeople : obj.numberpeople.o.value.trim(),
        comments : obj.comments.o.value.trim(),
        policy  : obj.acept_mail.o.checked ? 'yes' : 'no'
      }
    };

    if( obj.recaptcha ){
      grecaptcha.ready(function() {
        grecaptcha.execute(obj.recaptcha,{action: 'sendForm'}).then(function(token) {
          ajax(datos);
        });
      });
    } else {
      ajax(datos);
    };
  },
  obj = {
    url : $(form).data('url').trim(),
    idProd : $(form).data('id'),
    recaptcha : $(form).data('recaptcha').trim(),
    name : {
      o   : form.name,
      $p  : $(form.name).parent()
    },
    surname : {
      o   : form.surname,
      $p  : $(form.surname).parent()
    },
    telephone : {
      o   : form.telephone,
      $p  : $(form.telephone).parent()
    },
    email : {
      o   : form.email,
      $p  : $(form.email).parent()
    },
    hour : {
      o   : form.hour,
      $p  : $(form.hour).parent()
    },
    date : {
      o   : form.date,
      $p  : $(form.date).parent()
    },
    numberpeople : {
      o   : form.numberpeople,
      $p  : $(form.numberpeople).parent()
    },
    comments : {
      o   : form.comments,
      $p  : $(form.comments).parent()
    },
    policy : {
      o   : form.policy,
      $p  : $(form.policy).parent()
    },
    acept_mail : {
      o   : form.acept_mail,
      $p  : $(form.acept_mail).parent()
    },
    obligText : [],
    error : {
      $o : $( form.querySelector('.sta-error') ),
      copy : {
        $empty : $('<li id="g_form_error_empty"></li>').text( form.copyEmpty.value ),
        $email : $('<li id="g_form_error_email"></li>').text( form.copyEmail.value ),
        $policy : $('<li id="g_form_error_politicas"></li>').text( form.copyPoliticas.value ),
        $ok : $('<li></li>').text( form.copyOk.value )
      }
    }
  },
  processEnvio = false;

  obj.obligText.push( obj.name, obj.surname, obj.telephone, obj.email, obj.hour, obj.date, obj.numberpeople );

  $( form ).submit(function(e){
    e.preventDefault();
    
    if( !processEnvio ){
      processEnvio = true;
      if( valid() ) enviar();
    }
    
  });

  if( obj.recaptcha ) h.cargarFicheroJS('https://www.google.com/recaptcha/api.js?render='+obj.recaptcha);

})( document.querySelector('.formContactAmpliado'), window.jQuery, window.hotusa && hotusa() );

//formulario de arrepentimiento
(function( form, $, h ){
  if( !form || !$ || !h ) return false;

  var valid = function(){
    var enviar = true,
    empty = false;
    
    obj.error.$o.empty().removeClass('sta-cardpage-air_warning-text sta-cardpage-air_done-text');

    for (var i = 0; i < obj.obligText.length; i++) {
      (function( elem ){
        if( elem.o.value.trim() ){
          elem.$p.removeClass('invalid');
        } else {
          elem.$p.addClass('invalid');
          enviar = false;
          empty = true;
        }
      })( obj.obligText[i] );
    };

    if( empty ) obj.error.$o.append( obj.error.copy.$empty );
    
    if( obj.policy.o.checked ){
      obj.policy.$p.removeClass('invalid');
    } else {
      enviar = false;
      obj.policy.$p.addClass('invalid');
      obj.error.$o.append( obj.error.copy.$policy );
    };

    if( !enviar ){
      obj.error.$o.addClass('sta-cardpage-air_warning-text');
      processEnvio = false;
    };

    return enviar;
  },
  ajax = function( datos ){
    $.ajax({
      type: 'POST',
      url: window.location.pathname.replace('.html', '/form.html'),
      async: false,
      data: JSON.stringify( datos ),
      success: function (n) {
        processEnvio = false;
        switch (n) {
          case 'OK':
            form.reset();
            obj.error.$o.append( obj.error.copy.$ok ).addClass('sta-cardpage-air_done-text');
            break;
          case 'ERR':
            console.trace("Not template",n);
            break;
          case 'KO - Error Formato Datos JSON':
          case 'KO':
          default:
            console.trace(n);
            break;
        };
      },
      error: function (n) {
        processEnvio = false;
        console.trace("ERROR:", n);
      }
    });
  },
  enviar = function(){
    var datos = {
      d : {
        name    : obj.name.o.value.trim(),
        locator : obj.locator.o.value.trim(),
        policy  : obj.acept_mail.o.checked ? 'yes' : 'no'
      }
    };

    if( obj.recaptcha ){
      grecaptcha.ready(function() {
        grecaptcha.execute(obj.recaptcha,{action: 'sendForm'}).then(function(token) {
          ajax(datos);
        });
      });
    } else {
      ajax(datos);
    };
  },
  obj = {
    url : $(form).data('url').trim(),
    idProd : $(form).data('id'),
    recaptcha : $(form).data('recaptcha').trim(),
    name : {
      o   : form.name,
      $p  : $(form.name).parent()
    },
    locator : {
      o   : form.locator,
      $p  : $(form.locator).parent()
    },
    policy : {
      o   : form.policy,
      $p  : $(form.policy).parent()
    },
    acept_mail : {
      o   : form.acept_mail,
      $p  : $(form.acept_mail).parent()
    },
    obligText : [],
    error : {
      $o : $( form.querySelector('.sta-error') ),
      copy : {
        $empty : $('<li id="g_form_error_empty"></li>').text( form.copyEmpty.value ),
        $email : $('<li id="g_form_error_email"></li>').text( form.copyEmail.value ),
        $policy : $('<li id="g_form_error_politicas"></li>').text( form.copyPoliticas.value ),
        $ok : $('<li></li>').text( form.copyOk.value )
      }
    }
  },
  processEnvio = false;

  obj.obligText.push( obj.name, obj.locator );

  $( form ).submit(function(e){
    e.preventDefault();
    
    if( !processEnvio ){
      processEnvio = true;
      if( valid() ) enviar();
    }
    
  });

  if( obj.recaptcha ) h.cargarFicheroJS('https://www.google.com/recaptcha/api.js?render='+obj.recaptcha);

})( document.querySelector('.formArrepentimiento'), window.jQuery, window.hotusa && hotusa() );

//formulario de contacto + archivo
(function( form, $, h ){
  if( !form || !$ || !h ) return false;

  var valid = function(){
    var enviar = true,
    empty = false,
    fileSize = false,
    fileExt = false,
    sendFile = true;

    obj.error.$o.empty().removeClass('sta-cardpage-air_warning-text sta-cardpage-air_done-text');

    for (var i = 0; i < obj.obligText.length; i++) {
      (function( elem ){
        if( elem.o.value.trim() ){
          elem.$p.removeClass('invalid');
        } else {
          elem.$p.addClass('invalid');
          enviar = false;
          empty = true;
        }
      })( obj.obligText[i] );
    };

    if( empty ) obj.error.$o.append( obj.error.copy.$empty );
    
    if( !h.mail( obj.email.o.value.trim() ) ){
      enviar = false;
      obj.email.$p.addClass('invalid');
      obj.error.$o.append( obj.error.copy.$email );
    };
    
    if( obj.policy.o.checked ){
      obj.policy.$p.removeClass('invalid');
    } else {
      enviar = false;
      obj.policy.$p.addClass('invalid');
      obj.error.$o.append( obj.error.copy.$policy );
    };

    
    //files
    (function( file ){
      var files = file.o.files,
      sizeTotal = 0;

      sendFile = files.length;

      for (var i = 0; i < files.length; i++) {
        (function( file ){
          var size = file.size;//bytes
          sizeTotal += size;
          
          if( obj.file.ext.indexOf( file.type ) < 0 ){
            fileExt = true;
            enviar = false;
          };

          //10Mb max por archivo
          if( parseInt( size / (1024 * 1024) ) > 10 ){
            fileSize = true;
            enviar = false;
          };
        
        })( files[i] );
      };

      //25Mb max total archivos
      if( parseInt( sizeTotal / (1024 * 1024) ) > 25 ){
        fileSize = true;
        envio = false;
      };

      if( fileExt ) obj.error.$o.append( obj.error.copy.$fileExt );
      if( fileSize ) obj.error.$o.append( obj.error.copy.$fileSize );

      fileExt || fileSize ? file.$p.addClass('invalid') : file.$p.removeClass('invalid');

    })( obj.file );


    if( !enviar ){
      obj.error.$o.addClass('sta-cardpage-air_warning-text');
      processEnvio = false;
    };
    
    return enviar && sendFile ? sendFile : enviar;

  },
  ajaxFile = function(){
    var fd = new FormData( form );

    $.ajax({
      type: 'POST',
      url: window.location.pathname.replace('.html', '/form.html'),
      async: false,
      data: fd,
      cache: false,
      contentType: false,
      processData: false,
      success: function (n) {
        processEnvio = false;
        switch (n) {
          case 'OK':
            form.reset();
            obj.file.$p.removeClass('sta-fill');
            obj.error.$o.append( obj.error.copy.$ok ).addClass('sta-cardpage-air_done-text');
            break;
          case 'ERR':
            console.trace("Not template",n);
            break;
          case 'KO - Error Formato Datos JSON':
          case 'KO':
          default:
            console.trace(n);
            break;
        };
      },
      error: function (n) {
        processEnvio = false;
        console.trace("ERROR:", n);
      }
    });
  },
  ajaxNormal = function(){
    var datos = {
      d : {
        name    : obj.name.o.value.trim(),
        surname : obj.surname.o.value.trim(),
        email   : obj.email.o.value.trim(),
        comments: obj.comments.o.value.trim(),
        acept_mail: obj.acept_mail.o.checked ? 'ON' : ''
      }
    };

    $.ajax({
      type: 'POST',
      url: window.location.pathname.replace('.html', '/form.html'),
      async: false,
      data: JSON.stringify( datos ),
      success: function (n) {
        processEnvio = false;
        switch (n) {
          case 'OK':
            form.reset();
            obj.file.$p.removeClass('sta-fill');
            obj.error.$o.append( obj.error.copy.$ok ).addClass('sta-cardpage-air_done-text');
            break;
          case 'ERR':
            console.trace("Not template",n);
            break;
          case 'KO - Error Formato Datos JSON':
          case 'KO':
          default:
            console.trace(n);
            break;
        };
      },
      error: function (n) {
        processEnvio = false;
        console.trace("ERROR:", n);
      }
    });
  };
  enviar = function(file){
    if( obj.recaptcha ){
      grecaptcha.ready(function() {
        grecaptcha.execute(obj.recaptcha,{action: 'sendForm'}).then(function(token) {
          file ? ajaxFile() : ajaxNormal();
        });
      });
    } else {
      file ? ajaxFile() : ajaxNormal()
    };
  },
  obj = {
    url : $(form).data('url').trim(),
    idProd : $(form).data('id'),
    recaptcha : $(form).data('recaptcha').trim(),
    name : {
      o   : form.name,
      $p  : $(form.name).parent()
    },
    surname : {
      o   : form.surname,
      $p  : $(form.surname).parent()
    },
    email : {
      o   : form.email,
      $p  : $(form.email).parent()
    },
    file  : {
      o   : form['file[]'],
      $p  : $( form['file[]'] ).parent(),
      text: form.querySelector('.sta-file .sta-file_name'),
      ext : [
        'application/pdf',
        'application/vnd.openxmlformats-officedocument.wordprocessingml.document',
        'application/msword'
      ]
    },
    comments : {
      o   : form.comments,
      $p  : $(form.comments).parent()
    },
    policy : {
      o   : form.policy,
      $p  : $(form.policy).parent()
    },
    acept_mail : {
      o   : form.acept_mail,
      $p  : $(form.acept_mail).parent()
    },
    obligText : [],
    error : {
      $o : $( form.querySelector('.sta-error') ),
      copy : {
        $empty : $('<li id="g_form_error_empty"></li>').text( form.copyEmpty.value ),
        $email : $('<li id="g_form_error_email"></li>').text( form.copyEmail.value ),
        $policy : $('<li id="g_form_error_politicas"></li>').text( form.copyPoliticas.value ),
        $ok : $('<li></li>').text( form.copyOk.value ),
        $fileExt : $('<li></li>').text( form.copyFileExt.value ),
        $fileSize : $('<li></li>').text( form.copyFileSize.value )
      }
    }
  },
  processEnvio = false;

  obj.obligText.push( obj.name, obj.surname, obj.email, obj.comments );

  $( form ).submit(function(e){
    e.preventDefault();
    
    if( !processEnvio ){
      processEnvio = true;
      var _v = valid();
      if( _v === true ) enviar(false);
      else if( _v && typeof _v == 'number' ) enviar(true);
    };
  });

  //event change file
  (function( elem ){
    $( elem.o ).on('change',function(){
      elem.$p.removeClass('sta-fill invalid');
      
      var str = '',
      files = this.files;

      for (var i = 0; i < files.length; i++) {
        str += files[i].name;
        if( i < files.length - 1 ) str += ', ';
      }

      if( files.length ){
        elem.text.innerText = str;
        elem.$p.addClass('sta-fill');
      }
    })
  })( obj.file );

  if( obj.recaptcha ) h.cargarFicheroJS('https://www.google.com/recaptcha/api.js?render='+obj.recaptcha);

})( document.querySelector('.formArchivo'), window.jQuery, window.hotusa && hotusa() );

//formulario de denuncia
(function( form, $, h ){
  if( !form || !$ || !h ) return false;

  var valid = function(){
    var enviar = true,
    empty = false;

    obj.error.$o.empty().removeClass('sta-cardpage-air_warning-text sta-cardpage-air_done-text');

    for (var i = 0; i < obj.obligText.length; i++) {
      (function( elem ){
        if( elem.o.value.trim() ){
          elem.$p.removeClass('invalid');
        } else {
          elem.$p.addClass('invalid');
          enviar = false;
          empty = true;
        }
      })( obj.obligText[i] );
    };

    if( empty ) obj.error.$o.append( obj.error.copy.$empty );
    
    if( obj.policy.o.checked ){
      obj.policy.$p.removeClass('invalid');
    } else {
      enviar = false;
      obj.policy.$p.addClass('invalid');
      obj.error.$o.append( obj.error.copy.$policy );
    };

    if( !enviar ){
      obj.error.$o.addClass('sta-cardpage-air_warning-text');
      processEnvio = false;
    };

    return enviar;
  },
  ajax = function( datos ){
    $.ajax({
      type: 'POST',
      url: window.location.pathname.replace('.html', '/form.html'),
      async: false,
      data: JSON.stringify( datos ),
      cache: false,
      contentType: false,
      processData: false,
      success: function (n) {
        processEnvio = false;
        switch (n) {
          case 'OK':
            form.reset();
            obj.error.$o.append( obj.error.copy.$ok ).addClass('sta-cardpage-air_done-text');
            break;
          case 'ERR':
            console.trace("Not template",n);
            break;
          case 'KO - Error Formato Datos JSON':
          case 'KO':
          default:
            console.trace(n);
            break;
        };
      },
      error: function (n) {
        processEnvio = false;
        console.trace("ERROR:", n);
      }
    });
  },
  enviar = function(){
    var datos = {
      d : {
        comment1 : obj.comment1.o.value.trim(),
        comment2 : obj.comment2.o.value.trim(),
        comment3 : obj.comment3.o.value.trim(),
        policy  : obj.acept_mail.o.checked ? 'yes' : 'no'
      }
    };

    if( obj.recaptcha ){
      grecaptcha.ready(function() {
        grecaptcha.execute(obj.recaptcha,{action: 'sendForm'}).then(function(token) {
          ajax(datos);
        });
      });
    } else {
      ajax(datos);
    };
  },
  obj = {
    url : $(form).data('url').trim(),
    idProd : $(form).data('id'),
    recaptcha : $(form).data('recaptcha').trim(),
    comment1 : {
      o   : form.comment1,
      $p  : $(form.comment1).parent()
    },
    comment2 : {
      o   : form.comment2,
      $p  : $(form.comment2).parent()
    },
    comment3 : {
      o   : form.comment3,
      $p  : $(form.emacomment3il).parent()
    },
    policy : {
      o   : form.policy,
      $p  : $(form.policy).parent()
    },
    acept_mail : {
      o   : form.acept_mail,
      $p  : $(form.acept_mail).parent()
    },
    obligText : [],
    error : {
      $o : $( form.querySelector('.sta-error') ),
      copy : {
        $empty : $('<li id="g_form_error_empty"></li>').text( form.copyEmpty.value ),
        $policy : $('<li id="g_form_error_politicas"></li>').text( form.copyPoliticas.value ),
        $ok : $('<li></li>').text( form.copyOk.value )
      }
    }
  },
  processEnvio = false;

  obj.obligText.push( obj.comment1, obj.comment2, obj.comment3 );

  $( form ).submit(function(e){
    e.preventDefault();
    
    if( !processEnvio ){
      processEnvio = true;
      if( valid() ) enviar();
    };
  });

  if( obj.recaptcha ) h.cargarFicheroJS('https://www.google.com/recaptcha/api.js?render='+obj.recaptcha);

})( document.querySelector('.formDenuncia'), window.jQuery, window.hotusa && hotusa() );

// function internbar size
(function( o, $ ){
  if( o ){
    var checker = 0;
    //init slider
    function load_slider(){
      $('.sta-internbar-air_links',o).slick({
        dots: false,
        arrows: false,
        infinite: false,
        useTransform: true,
        fade: false,
        cssEase: 'cubic-bezier(0.785, 0.135, 0.15, 0.86)',
        speed: 750,
        //slidesToShow: 8,
        autoplay: false,
        variableWidth: true,
        swipeToSlide: true,
        responsive: [
          {
            breakpoint: 1279,
            settings: {
              //slidesToShow: 8,
              slidesToScroll: 1,
            }
          },
        ]
      });
    }
    if(window.innerWidth >= 1024){
      loadScript("/templates/cadenas/air/js/libraries/slick.min.js", load_slider);
      loadStyle("/templates/cadenas/air/css/libraries/slick.min.css");
      checker = 1;
    }else{
      var check_responsive = 1;
      $(window).resize(function(){
        if(window.innerWidth < 1024){
          if( $().slick ){
            //$('.sta-internbar-air_links').slick('unslick');
            checker = 0;
          }
        }else{
          if(checker === 0){
            if(check_responsive === 1){
              loadScript("/templates/cadenas/air/js/libraries/slick.min.js", load_slider);
              loadStyle("/templates/cadenas/air/css/libraries/slick.min.css");
              check_responsive = 0;
            }
            //load_slider();
            checker = 1;
          }
        }
      })
    }
    
  }
})( document.querySelector('.sta-dinamic-size'), window.jQuery );

(function( o, $ ){
  if( !o || !$ ) return false;

  var elems = o.querySelectorAll('.sta-breadcrumbs-air_element'),
  script = document.createElement('script'),
  datos = {
    "@context"        : "http://schema.org/",
    "@type"           : "BreadcrumbList",
    itemListElement   : []
  };

  for (var i = 0; i < elems.length; i++) {
    (function( $a, posi, $last ){
      if( !$last ){
        var _tmp = {
          "@type" : "ListItem",
          position: posi,
          item    : {
            name : $a.text().trim(),
            "@id": $a.attr('href')
          }
        };
        datos.itemListElement.push( _tmp );
      } else {
        var _tmp = {
          "@type" : "ListItem",
          position: posi,
          item    : {
            name : $last.text().trim(),
            "@id": location.origin + location.pathname
          }
        };
        datos.itemListElement.push( _tmp );
      }
      //if( $last ) $last.html( _tmp.item.name );
    })( $( elems[i].querySelector('a') ), i+1, (i == elems.length-1 ? $( elems[i] ) : false ) );
  };

  if( datos.itemListElement.length ){
    script.title = "BreadcrumbList";
    script.type = "application/ld+json";
    script.innerHTML = JSON.stringify(datos);
    $(document.head).append(script);
  }

})( document.querySelector('.tgl-breadcrumbs-air'), window.jQuery );

(function(a, $){
  if(!a.length || !$) return false;
  var ev = function(o){
    if( o.querySelectorAll('.sta-serviciosNew-air_max ul li').length > 8 ){
      var $list = $(o.querySelector('.sta-serviciosNew-air_max')),
      $bMore = $('<button />',{class:'sta-serviciosNew-air_ver'})
      .appendTo( o ).text( $(o).data('buttons_mas') ),
      textMas = $(o).data('buttons_mas'),
      textMenos = $(o).data('buttons_menos'),
      bMas = true;
      $list.addClass('sta-menos');
      $bMore.on('click', function(){
        $list.toggleClass('sta-menos')
        if( bMas ){
          $bMore.text(textMenos);
          bMas = false;
        }else{
          $bMore.text(textMas);
          bMas = true;
        }
      })
    }
  };
  for (var i = 0; i < a.length; i++) ev(a[i]);
})(document.querySelectorAll('.tpl-serviciosNew-air'), window.jQuery);


//Hs
(function( $, opt1, opt2, opt3, opt4, opt5, opt6, opt7 ) {
  if( !$ ) return false;

  var orden = [
    {
      query : '.sta-products-air_header .sta-products-air_header-title',
      o     : opt1
    },
    {
      query : '.sta-intro-air_title',
      o     : opt2
    },
    {
      query : '.sta-cover-air_intro .sta-cover-air_text',
      o     : opt3
    },
    {
      query : '.sta-internbar-air_header-title',
      o     : opt4
    },
    {
      query : '.sta-breadcrumbs-air_list .sta-breadcrumbs-air_element:last-of-type',
      o     : opt5
    },
    {
      query : '.sta-cardpage-air_intro .sta-cardpage-air_intro-title',
      o     : opt6
    },
    {
      query : '.sta-cardpage-air_preheader .sta-cardpage-air_preheader-title',
      o     : opt7
    }
  ],
  posi = 0,
  controlH = function (obj) {
    if( !obj ){
      console.trace("No se han podido colocar los H1's")
      return false;
    };
    if( obj.o ){
      var title = obj.o.querySelector( obj.query );
      
      if( title && title.textContent.trim() ){
        $( title ).html( $('<h1></h1>').html( title.innerHTML ) );
      } else {
        controlH( orden[++posi] );
      };
    } else {
      controlH( orden[++posi] );
    };
  };

  controlH( orden[posi] );

})( window.jQuery, document.querySelector('.tgl-reviews-air'), document.querySelector('.tgl-intro-air'), document.querySelector('.tgl-cover-air:not(.sta-devices-hide)'), document.querySelector('.tgl-internbar-air'), document.querySelector('.tgl-breadcrumbs-air'), document.querySelector('.tgl-cardpage-air.sta-pretitleNone'), document.querySelector('.tgl-cardpage-air') );





/*Funcion galeria instagram*/
(function (src,$,h) {
  $(document).ready(function(){
      var a = $( document.querySelectorAll(src) );
      a.each(function(){
          var o = this,
          text = $(o).data('text'),
          token = $(o).data('token'),
          callback = function () {
              h.cargarFicheroJS('/js/libraries/spectagram/spectragram.min.js',function(){
                  jQuery.fn.spectragram.accessData={
                      accessToken:token
                  };
                  $('.sta-instagramGallery-air_container',o).spectragram({
                      max: 12,
                      wrapEachWith: '<div class="sta-instagramGallery-air_elemento"></div>',
                      complete : getInfoImage
                  });
              });
              
              function getInfoImage(){
                  var html = $('<div class="sta-instagramGallery-air_tableContainer"><div class="sta-instagramGallery-air_table"><div class="sta-instagramGallery-air_tableCellContainer"><span class="sta-instagramGallery-air_textContainer"></span><span class="sta-instagramGallery-air_textSpan">'+text+'</span></div></div></div>');
                  function crearHtml(info){
                      var ret = html.clone();
                      $('.sta-instagramGallery-air_textContainer',ret).prepend(info);
                      return ret
                  }
                  $('.sta-instagramGallery-air_elemento').each(function(i,e){
                      var a = $('a',this),
                      alt = a.attr('title');
                      a.append(crearHtml(alt)).attr('title','');
                  })
                  $(o).addClass('sta-complete');
              }
          }
          if( token ) h.cargaScrollAuto({obj:o},callback);
      });
  })
})( '.tgl-instagramGallery-air',jQuery,hotusa());

// meta og:image
(function( o,seo ){
  if(!o || o.content || !seo || !seo.imgFirst ) return false;
  o.content= seo.imgFirst;
})( document.head.querySelector('.openGraphFirstImage'), window.dataSeo );

// meta theme-color
(function( m,$ ){
  if( !m || !$ )return false;

  var color = $(m).css('color'),
  lastMeta = document.head.querySelector('meta:last-of-type'),
  meta = document.createElement('meta');
  meta.name = 'theme-color';
  meta.content = color;

  lastMeta.parentNode.insertBefore(meta,lastMeta);
})( document.querySelector('.tgl-menus-air .sta-menus-air_nav-logo'), window.jQuery );

function crearGaleria(url) {
  var modalGaleria = document.createElement('div'),
  div = document.createElement('div');
  modalGaleria.classList.add('modalGaleria'),
  button = document.createElement('button');
  button.classList.add('close')
  div.classList.add('containerImg')
  modalGaleria.appendChild(div).style.backgroundImage = 'url(' + url + ')';
  modalGaleria.appendChild(button)
  document.body.appendChild(modalGaleria);
  document.body.style.overflow = 'hidden';
  button.onclick = function() {
      modalGaleria.classList.remove('active');
      modalGaleria.remove();
      document.body.style.overflow = 'auto';
  }
}
 
var gamasCromaticas = (function( link, h ){
  var actual = 0,
  url = '/templates/cadenas/air/css/colors/',
  colors = ['007d69','77a687','BAC5B9','DC6D47','495461','C0D185','1E521A','64280c','b7bbcc','b9ab98','3386FF','406693','28b36f','f07e26','cb0339','fab833','76dce1','a92a0a','F66C5E','3E511C','856f52','c7a84f','0b0e3d','B58C30','232EBE', 'A5AFB1', 'ffd200','05a4de','92133E','B2A89C','A0434B','c23e3e','78C0C5','391832','935485','dfad58', 'eba9a9','B27B22','BD9C67','8AB0B1','373737','F2930D','C2A472','DDA385','5CBB47','BEAD50', '913C26', 'AC8B25','B0BB16','205253','DDD5B0'].sort(),
  cookie = false,
  custom = h.getSessionStorageJSON('test_GC') && h.getSessionStorageJSON('test_GC').var ? h.getSessionStorageJSON('test_GC').var : false,
  getCookie = h.getSessionStorageJSON('test_GC'),
  fn = function (str) {
    if( typeof str != 'string' ){
      if( actual >= colors.length ) actual = 0;
      str = colors[actual];
      actual++;
    } else if( str === 'lista' ){
      console.log('%cListado de Gamas Cromáticas',"background:#000;padding:10px 20px;font:20px Georgia;color:#fff")
      for (var i = 0; i < colors.length; i++) {
        colors[i]
        ? console.log('%cCódigo color: '+colors[i],"background:#"+colors[i]+";padding:10px 20px;font:20px Georgia;color:#fff")
        : console.log('%cCódigo color: c2a472',"background:#c2a472;padding:10px 20px;font:20px Georgia;color:#fff");
      };
      
      console.log('%cRecuerda que puedes:\n  · Alternar entre las GC existentes: gamasCromaticas()\n  · Listar las GC: gamasCromaticas("lista")\n  · Activar modo testing (puedes cambiar de página manteniendo la GC): gamasCromaticas("prueba")\n  · Crear tu propia GC (necesitas saber el color en hexadecimal): gamasCromaticas("custom")',"background:#000;padding:2px 10px;font:12px Georgia;color:#fff")
      return false;
    } else if( str === 'prueba' ){
      cookie = true;
      console.log('%cSe guardará la gama cromática seleccionada en una cookie para testear, se borrará al cerrar ventana.',"background:#000;padding:10px 20px;font:20px Georgia;color:#fff");
      return false;
    } else if( str === 'custom' ){
      cookie = true;
      if( !custom ) custom = window.prompt('Indique el código hexadecimal del color que quiera aplicar','#406693');
      console.log('%cCódigo color: '+custom,"background:"+custom+";padding:10px 20px;font:20px Georgia;color:#fff");
      console.log('%cSe guardará la gama cromática seleccionada en una cookie para testear, se borrará al cerrar ventana.',"background:#000;padding:10px 20px;font:20px Georgia;color:#fff");
      str = 'variable';
      document.body.style.setProperty("--bg", custom);
    };

    //NOT GC
    if( !link ){
      link = document.createElement('link');
      link.rel = 'stylesheet';
      link.as = 'style';
      var lastLink = document.head.querySelector('link:last-of-type');
      lastLink.parentNode.insertBefore(link,lastLink);
    };

    if( str ){
      link.href = url + str + '.css';
      str.length == 3 || str.length == 6
      ? console.log('%cGama cromática "'+str+'" asignada', "background:#"+str+";padding:10px 20px;font:20px Georgia")
      : console.log('%cGama cromática "'+str+'" asignada', "background:#000;padding:10px 20px;font:20px Georgia");
    } else {
      link.href = '';
      console.log('%cGama cromática inicial "c2a472" recuperada', "background:#c2a472;padding:10px 20px;font:20px Georgia");
    };

    if( cookie && !custom ) h.setSessionStorageJSON('test_GC',{color:str});
    if( cookie && custom ) h.setSessionStorageJSON('test_GC',{color:'custom',var:custom});
  };
  colors.push('');

  if( getCookie ) fn(getCookie.color);

  return fn;
})( document.querySelector('.gamaCromatica'), window.hotusa && hotusa() );


//viewport in safary
(function( meta ){
  if( !meta || !/^((?!chrome|android).)*safari/i.test(navigator.userAgent) ) return false

  var contentOld = meta.content;
  meta.content = meta.attributes.saf.value;

})( document.head.querySelector('.metaViewport') );

(function () {
  if (!window.frontLoader) {return false};
  const existLogin = window.frontLoader["cms-login"]?.config;
  if (existLogin){
    document.querySelector('.sta-corporate').classList.remove('hideLogin');
  }
})();

// Arreglar z-index de tgl-internbar-air
(function () {
  document.addEventListener('DOMContentLoaded', function () {
    const el = document.querySelector('.tgl-internbar-air');
    const refEl = document.querySelector('.tgl-menus-air .sta-menus-air_nav');
    if (!el || !refEl) return;

    function checkElementoCercaDelTop() {
      const top = el.getBoundingClientRect().top;
      const refHeight = refEl.offsetHeight;

      if (top <= refHeight) {
        el.classList.add('internbar-air-top');
        el.classList.remove('internbar-air-bottom');
      } else {
        el.classList.add('internbar-air-bottom');
        el.classList.remove('internbar-air-top');
      }
    }

    window.addEventListener('scroll', checkElementoCercaDelTop);
  });
})();

// Para evitar clicks en el slider mientras se arrastra
(function() {
  let isDragging = false;
  let startX = 0;
  let startY = 0;
  const slickSlider = document.querySelector('.slick-list');
  if (slickSlider) {
    slickSlider.addEventListener('mousedown', (e) => {
      isDragging = false;
      startX = e.clientX;
      startY = e.clientY;
    });
    slickSlider.addEventListener('mousemove', (e) => {
      if (Math.abs(e.clientX - startX) > 5 || Math.abs(e.clientY - startY) > 5) {
        isDragging = true;
      }
    });
    slickSlider.addEventListener('mouseup', () => {
      setTimeout(() => isDragging = false, 50);
    });
    document.querySelectorAll('.js-scrollto').forEach(element => {
      element.addEventListener('click', function(event) {
        if (isDragging) {
          event.preventDefault();
          event.stopImmediatePropagation();
          return false;
        }
      }, true);
    });
  }
})();

// Listener para los campos del formulario 
document.addEventListener('DOMContentLoaded', () => {
  const fields = document.querySelectorAll('.sta-input-field:not([type="date"]):not([type="time"]), .sta-textarea-field');

  fields.forEach(field => {
    const container = field.parentElement;

    const toggleLabel = () => {
      if (field.value.trim() !== '' || document.activeElement === field) {
        container.classList.add('active');
      } else {
        container.classList.remove('active');
      }
    };
    field.addEventListener('focus', toggleLabel);
    field.addEventListener('blur', toggleLabel);
    field.addEventListener('input', toggleLabel);

    toggleLabel();
  });

  // Desplegables de los forms
  const fechaInput = document.getElementById("form_date");
  const horaInput = document.getElementById("form_time");
  if (fechaInput) {
    fechaInput.addEventListener("click", (e) => {fechaInput.showPicker();});
  }
  if (horaInput) {
    horaInput.addEventListener("click", (e) => {horaInput.showPicker();});
  }
});

//Eliminar <a></a> sin href
document.addEventListener('DOMContentLoaded', () => {
  document.querySelectorAll('a[href]').forEach(element => {
     if (element.getAttribute('href').trim() === '') {
        element.remove();
      }
  });
});

// Ajustar el ancho de los elementos del popup al texto más largo
(function() {
  const textSelector = '#tgl-modals .sta-popoffer-air_gadget .sta-popoffer-air_gadget-btn .sta-popoffer-air_gadget-text';
  const containerSelector = '#tgl-modals .sta-popoffer-air_gadget';
  const textElements = document.querySelectorAll(textSelector);
  const containerElements = document.querySelectorAll(containerSelector);

  if (!textElements.length || !containerElements.length) return;
  const tempSpan = document.createElement('span');
  Object.assign(tempSpan.style, {position: 'absolute',visibility: 'hidden',whiteSpace: 'nowrap',});
  document.body.appendChild(tempSpan);

  let maxWidth = 0;
  textElements.forEach(el => {
    if (el && el.textContent) {
      tempSpan.textContent = el.textContent.trim();
      const width = tempSpan.getBoundingClientRect().width;
      if (width > maxWidth) maxWidth = width;
    }
  });

  document.body.removeChild(tempSpan);
  maxWidth = Math.min(maxWidth, 150);
  const textWidth = Math.ceil(maxWidth);
  const containerWidth = textWidth + 63;
  textElements.forEach(el => {if (el && el.style) el.style.width = textWidth + 'px';});
  containerElements.forEach(container => {if (container && container.style) container.style.width = containerWidth + 'px';});
})();

////////////////////////////////////////////////
/////////////////
//----POPUPS----
/////////////////
////////////////////////////////////////////////
(function (popoffer, modalContainer) {
  if (!popoffer || !modalContainer) return false;

  if (document.querySelector(".sta-mainDispo")) {
    modalContainer.remove();
    return false;
  }
})(
  document.querySelector(".tgl-popoffer-air"),
  document.getElementById("tgl-modals")
);

//////
//  Función que inicializa popups y los muestra segun ciertos criterios
//////

(function (popups, $, hotusaLib, reserva) {
  if (!popups.length || !$ || !hotusaLib) return false;

  const popupConfig = window.popupConfig;
  const pathname = window.location.pathname;
  const popupTimer = window.popupTimer * 1000;
  var currentlyOpenPopup = null;

  /**
   * Guarda el popup como mostrado en sessionStorage
   */
  const markPopupAsShown = (SESSION_KEY) => {
    const cookies = hotusaLib.getCookie("controlCookies");
    if (!cookies) return;

    if (JSON.parse(cookies).functional) {
      hotusaLib.setSessionStorageJSON(SESSION_KEY, true);
    }
  };
  /**
   * Abre el popup
   */
  const openPopup = (popupElement, $closer, SESSION_KEY) => {
    popupElement.classList.add("fn-open");
    currentlyOpenPopup = popupElement;
    $closer.click(() => markPopupAsShown(SESSION_KEY));
  };

  /**
   * Abre el popup
   */
  const pathnameFinder = (id) => {
    const key = String(id);
    if (!(key in popupConfig)) return true;

    return popupConfig[key].includes(pathname);
  };

  /**
   * EVENTOS
   */
  const initEvents = ($opener, $closer, popupElement) => {
    $opener.click(function (event) {
      event.stopPropagation();

      // si había otro popup abierto y era un aside pequeño, lo cierra
      if (currentlyOpenPopup?.classList.contains("sta-small-aside")) {
        currentlyOpenPopup.classList.remove("fn-open");
      }

      popupElement.classList.add("fn-open");
      currentlyOpenPopup = popupElement;
    });

    $closer.click(function () {
      popupElement.classList.remove("fn-open");
      currentlyOpenPopup = null;
    });
  };

  ///Inicializa un popup concreto
  const initPopup = function (popupElement) {
    const openClass = popupElement.dataset.open;
    const popupID = openClass.split("_")[1];
    const $opener = $(document.querySelectorAll("." + openClass));
    const $closer = $(popupElement.querySelectorAll(".js-close-popoffer"));

    const SESSION_KEY = "modal_" + openClass;
    const autoOpenSesion = hotusaLib.getSessionStorageJSON(SESSION_KEY);

    // Asegura que los enlaces dentro del popup se abran en pestaña nueva
    hotusa().enlace_blank(
      $(popupElement.querySelector(".sta-popoffer-air_btns a"))
    );
    popupElement.style.display = "block";
    initEvents($opener, $closer,popupElement);

    if (autoOpenSesion || reserva) return;
    if (popupElement.classList.contains("sta-init-hide")) return;
    if (!popupConfig) return;
    if (!pathnameFinder(popupID)) return;

    setTimeout(() => openPopup(popupElement, $closer, SESSION_KEY), popupTimer);

    /////////////////////////////////////////
  };

  //Evento click global
  $(document).click(function (event) {
    // si hay un popup abierto y el clic se hizo fuera
    if (
      currentlyOpenPopup &&
      currentlyOpenPopup.querySelector(".sta-popoffer-air_box") === event.target
    ) {
      currentlyOpenPopup.classList.remove("fn-open"); // cierra el popup
      currentlyOpenPopup = null;
    }
  });

  // inicializa todos los popups encontrados en la página
  popups.forEach((popupElement) => {
    initPopup(popupElement);
  });
})(
  document.querySelectorAll(".tgl-popoffer-air"), // lista de popups
  window.jQuery,
  window.hotusa && hotusa(),
  document.querySelector(".tgl-enginepage-air.sta-big-wrapper.sta-first") // página de reserva
);
////////////////////////////////////////////
//////////////////////////////////////////
//----VIDEOS----
//////////////////////////////////////////

//add class banner with video
(function (a, $) {
  if (!a.length || !$) return false;

  for (var i = 0; i < a.length; i++) {
    (function (o) {
      var $elem = $(o.querySelector(".sta-banner-air_multimedia-video"));
      if (!$elem.length || !($elem.data("video") || $elem.data("video-wistia")))
        return false;
      $(o).addClass("sta-video-on");
    })(a[i]);
  }
})(document.querySelectorAll(".tgl-banner-air"), window.jQuery);

//add class cover with video && seo first img
(function (o, $, seo) {
  if (!o || !$ || !seo) return false;

  if (o.classList.contains("js-dualGallery")) {
    var jsDG = window.jsDualGallery,
      contGallery = o.querySelector(".sta-cover-air_multimedia"),
      addImgs = function (aDesk, aMovil) {
        if (aMovil && window.innerWidth < 1000) aDesk = aMovil;

        contGallery.textContent = "";
        for (var i = 0; i < aDesk.length; i++) {
          (function (a) {
            var figure = document.createElement("figure"),
              imgFigure = document.createElement("img");

            figure.style.backgroundImage = 'url("' + a.url + '")';
            imgFigure.src = 'url("' + a.url + '")';

            figure.className = "sta-cover-air_photo";
            figure.setAttribute("role", "img");
            figure.setAttribute("aria-label", "");

            imgFigure.className = "imgOcultaAda";
            imgFigure.alt =
              window.dataSeo &&
              window.dataSeo.hotel &&
              window.dataSeo.hotel.name
                ? window.dataSeo.hotel.name
                : "";

            figure.append(imgFigure);

            contGallery.append(figure);
          })(aDesk[i]);
        }
      };
    if (!jsDG) {
      console.trace("ERROR: Global Variable jsDualGallery Not Found");
    } else {
      jsDG.movil.length == jsDG.desk.length
        ? addImgs(jsDG.desk, jsDG.movil)
        : addImgs(jsDG.desk);
    }
  }

  var $elem = $(o.querySelector(".sta-cover-air_video-element")),
    img = o.querySelector(".sta-cover-air_multimedia .sta-cover-air_photo img");

  if (window.putCoverArrow) putCoverArrow();

  if (seo && img)
    seo(
      o.querySelector(".sta-cover-air_multimedia .sta-cover-air_photo img").src
    );
  if (!$elem.length || !($elem.data("video") || $elem.data("video-wistia")))
    return false;

  $(o).addClass("sta-video-on");
})(
  document.querySelector(".tgl-cover-air"),
  window.jQuery,
  window.crearDatosExtructurados
);

// function modular video
(function (a, $, h) {
  if (!a.length || !$ || !h) return false;

  var API_YOUTUBE = "https://www.youtube.com/iframe_api",
    API_WISTIA = "https://fast.wistia.net/assets/external/E-v1.js",
    vidRescale = function ($o) {
      var video = $(".embed_youtube", $o);
      (vidRatio = 16 / 9),
        (wrapperHeight = $o.height()),
        (wrapperWidth = $o.width()),
        (wrapperRatio = wrapperWidth / wrapperHeight);

      if (wrapperRatio < vidRatio) {
        var newWidth = wrapperWidth * (vidRatio / wrapperRatio);
        video.css({
          "min-height": wrapperHeight + "px",
          "min-width": newWidth + "px",
          position: "absolute",
          left: "50%",
          "margin-left": "-" + newWidth / 2 + "px",
        });
      } else {
        var newHeight = wrapperHeight * (wrapperRatio / vidRatio);
        video.css({
          "min-height": newHeight + "px",
          "min-width": wrapperWidth + "px",
          position: "absolute",
          top: "50%",
          "margin-top": "-" + newHeight / 2 + "px",
        });
      }
    },
    cargaYoutube = function ($mod, id, $insert) {
      var onPlayerReady = function (ev) {
          ev.target.setPlaybackQuality("hd1080");
          ev.target.unMute();
          ev.target.mute();
          ev.target.playVideo();
        },
        onPlayerStateChange = function (ev) {
          if (ev.data === YT.PlayerState.PLAYING) {
            $insert.addClass("fn-loaded");
            if (obj.cover) {
              vidRescale($mod);
              if (first) {
                first = false;
                $(window).on("resize", function () {
                  vidRescale($mod);
                });
              }
            }
            $mod.addClass("sta-videoActive");
            if (obj.sound) {
              if (
                navigator.userAgent.toLowerCase().indexOf("chrome") > -1 ||
                navigator.userAgent.toLowerCase().indexOf("safari") > -1
              ) {
                console.trace(
                  "Error: Chromium y iPhone no permite autoplay con videos con sonido.\n",
                  "https://goo.gl/xX8pDD"
                );
              } else {
                ev.target.unMute();
                ev.target.playVideo();
              }
            } else {
              ev.target.mute();
            }
          }
        },
        obj = {
          player: null,
          $frame: false,
          cover: !$mod.hasClass("not-videoCover") ? true : false,
          sound: $mod.hasClass("sta-videoSound") ? true : false,
          json: {
            videoId: id,
            playerVars: {
              showinfo: 0,
              modestbranding: 1,
              iv_load_policy: 3,
              enablejsapi: 1,
              playlist: id,
              loop: 1,
              controls: 0,
              hd: 1,
              height: 1080,
              width: 1920,
            },
            events: {
              onReady: onPlayerReady,
              onStateChange: onPlayerStateChange,
            },
          },
        },
        first = true;

      YT.ready(function () {
        obj.player = new YT.Player("idYoutube_" + id, obj.json, {
          videoId: id,
          host: "https://www.youtube.com",
        });
      });
    },
    cargaWistia = function ($mod, id, $insert) {
      $mod.addClass("loadVideoWistia");
      $("<div></div>", {
        class: "wistia_embed wistia_async_" + id,
        id: "idWistia_" + id,
      }).appendTo($insert);
      window._wq = window._wq || [];

      _wq.push({
        id: "idWistia_" + id,
        options: {
          endVideoBehavior: "loop",
          autoPlay: true,
          videoFoam: false,
          playButton: false,
          playbar: false,
          smallPlayButton: false,
          fullscreenButton: false,
          volumeControl: false,
          volume: $mod.hasClass("sta-videoSound") ? 1 : 0,
        },
        onReady: function (video) {
          video.bind("play", function (e) {
            $insert.addClass("fn-loaded");
            $mod.addClass("sta-videoActive");

            if (!$mod[0].classList.contains("cargado")) {
              var newButton = document.createElement("button");
              var container = $mod[0];
              newButton.className = "btn-sound muted";
              newButton.ariaLabel = "Silenciar audio";

              container.appendChild(newButton);

              const mediaQuery = window.matchMedia(
                "(min-width: 800px) and (max-width: 1024px)"
              );

              if (mediaQuery.matches &&
                container.classList.contains("tgl-cover-air")) 
              {
                const el = document.getElementById("default_sygy_element_engine");
                const offest = 10;
                newButton.style.bottom = el.clientHeight + offest + "px";
              }

              newButton
                .addEventListener("click", function () {
                  if (video.isMuted()) {
                    if (newButton.classList.contains("muted")) {
                      newButton.classList.remove("muted");
                      newButton.classList.add("unmuted");
                    }
                    video.unmute();
                  } else {
                    if (newButton.classList.contains("unmuted")) {
                      newButton.classList.remove("unmuted");
                      newButton.classList.add("muted");
                    }
                    video.mute();
                  }
                });
              container.classList.add("cargado");
            }
          });
          video.play();
        },
      });

      h.cargarFicheroJS(API_WISTIA);
    };

  for (var i = 0; i < a.length; i++) {
    (function (o) {
      var $insert = $(o.querySelector(".sta-insert-video")),
        id_youtube = $insert.data("video"),
        id_wistia = $insert.data("video-wistia");

      if (
        !(id_youtube || id_wistia) ||
        !(window.innerWidth >= 1280 || $(o).hasClass("sta-videoMovil"))
      )
        return false;

      h.cargaScrollAuto({ obj: o, dual: true }, function () {
        if (id_youtube) {
          $(o).hover(function () {
            $insert.append(
              $("<div></div>", {
                class: "embed_youtube",
                id: "idYoutube_" + id_youtube,
              })
            );

            h.cargarFicheroJS(API_YOUTUBE, function () {
              cargaYoutube($(o), id_youtube, $insert);
            });
          });
        } else if (id_wistia) {
          cargaWistia($(o), id_wistia, $insert);
        }
      });
    })(a[i]);
  }
})(
  document.querySelectorAll(".sta-video-on"),
  window.jQuery,
  window.hotusa && hotusa()
);

// Accesibilidad tablas (scopes y caption)
(function() {
  document.addEventListener("DOMContentLoaded", function() {
    document.querySelectorAll("table").forEach(tabla => {
      // Encabezados de columna
      const primeraFila = tabla.rows[0];
      if (primeraFila) {
        Array.from(primeraFila.cells).forEach(celda => {
          if (celda.tagName === "TH") {
            celda.setAttribute("scope", "col");
          }
        });
      }

      // Encabezados de fila
      Array.from(tabla.rows).slice(1).forEach(fila => {
        const primeraCelda = fila.cells[0];
        if (primeraCelda && primeraCelda.tagName === "TH") {
          primeraCelda.setAttribute("scope", "row");
        }
      });

      // Caption (caption-visibility)
      if (!tabla.querySelector("caption")) {
        const section = tabla.closest("section");
        if (section) {
          const titulo = section.querySelector(".sta-intro-air_header .sta-intro-air_title");
          if (titulo) {
            const caption = document.createElement("caption");
            caption.className = "caption-visibility";
            caption.textContent = titulo.textContent.trim();
            tabla.insertBefore(caption, tabla.firstChild);
          }
        }
      }
    });
  });
})();